/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.AbstractMessageObserver;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.EmptyBody;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.NonRelevantBodyObserver;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.EOFWhileReadingLineException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response
extends Message {
    private static final Logger log = LoggerFactory.getLogger((String)Response.class.getName());
    private static final Pattern pattern = Pattern.compile("HTTP/(\\d\\.\\d) (\\d\\d\\d)( (.*?))?$");
    private int statusCode;
    private String statusMessage;
    private static String SERVER_HEADER = "Membrane Service Proxy " + Constants.VERSION + ". See http://membrane-soa.org";

    public static ResponseBuilder ok(String msg) throws Exception {
        return Response.ok().contentType("text/html;charset=UTF-8").body(msg);
    }

    public static ResponseBuilder ok() {
        return ResponseBuilder.newInstance().status(200, "Ok").header("Server", SERVER_HEADER).bodyEmpty();
    }

    public static ResponseBuilder noContent() {
        return ResponseBuilder.newInstance().status(204, "No Content").bodyEmpty();
    }

    public static ResponseBuilder notModified(String date) {
        return ResponseBuilder.newInstance().status(304, "Not Modified").header("Server", SERVER_HEADER).header("Date", date).bodyEmpty();
    }

    public static ResponseBuilder badRequest() {
        return ResponseBuilder.newInstance().status(400, "Bad Request").header("Server", SERVER_HEADER).bodyEmpty();
    }

    public static ResponseBuilder badRequest(String message) {
        return ResponseBuilder.newInstance().status(400, "Bad Request").header("Server", SERVER_HEADER).contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Bad Request", message));
    }

    public static ResponseBuilder badRequest(String message, boolean escape) {
        return ResponseBuilder.newInstance().status(400, "Bad Request").header("Server", SERVER_HEADER).contentType("text/html;charset=UTF-8").body(escape ? Response.htmlMessage("Bad Request", message) : Response.unescapedHtmlMessage("Bad Request", message));
    }

    public static ResponseBuilder continue100() {
        return ResponseBuilder.newInstance().status(100, "Continue");
    }

    public static ResponseBuilder redirect(String uri, boolean permanent) {
        String escaped = StringEscapeUtils.escapeXml((String)uri);
        return ResponseBuilder.newInstance().status(permanent ? 301 : 307, permanent ? "Moved Permanently" : "Temporary Redirect").header("Location", uri).contentType("text/html;charset=UTF-8").body(Response.unescapedHtmlMessage("Moved.", "This page has moved to <a href=\"" + escaped + "\">" + escaped + "</a>."));
    }

    public static ResponseBuilder redirectGet(String uri) {
        String escaped = StringEscapeUtils.escapeXml((String)uri);
        return ResponseBuilder.newInstance().status(303, "Temporary Redirect").header("Location", uri).contentType("text/html;charset=UTF-8").body(Response.unescapedHtmlMessage("Moved.", "This page has moved to <a href=\"" + escaped + "\">" + escaped + "</a>."));
    }

    public static ResponseBuilder redirectWithout300(String uri) {
        String escaped = StringEscapeUtils.escapeXml((String)uri);
        return Response.redirectWithout300(uri, " This page has moved to <a href=\"" + escaped + "\">" + escaped + "</a>.");
    }

    public static ResponseBuilder redirectWithout300(String uri, String body) {
        String escaped = StringEscapeUtils.escapeXml((String)uri);
        return ResponseBuilder.newInstance().status(200, "OK").header("Location", uri).contentType("text/html;charset=UTF-8").body("<html><head><meta http-equiv=\"refresh\" content=\"0;URL='" + escaped + "'\" /></head><body>" + body + "</body>");
    }

    private static String unescapedHtmlMessage(String caption, String text) {
        return "<html><head><title>" + caption + "</title></head><body><h1>" + caption + "</h1><p>" + text + "</p></body></html>";
    }

    private static String htmlMessage(String caption, String text) {
        return Response.unescapedHtmlMessage(StringEscapeUtils.escapeHtml((String)caption), StringEscapeUtils.escapeHtml((String)text));
    }

    public static ResponseBuilder serverUnavailable(String message) {
        return ResponseBuilder.newInstance().status(503, "Service Unavailable").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Service Unavailable", message));
    }

    public static ResponseBuilder internalServerError() {
        return ResponseBuilder.newInstance().status(500, "Internal Server Error").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Internal Server Error", ""));
    }

    public static ResponseBuilder internalServerError(String message) {
        return ResponseBuilder.newInstance().status(500, "Internal Server Error").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Internal Server Error", message));
    }

    public static ResponseBuilder badGateway(String message) {
        return ResponseBuilder.newInstance().status(502, "Bad Gateway").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Bad Gateway", message));
    }

    public static ResponseBuilder gatewayTimeout(String message) {
        return ResponseBuilder.newInstance().status(504, "Gateway timeout").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Gateway timeout", message));
    }

    public static ResponseBuilder forbidden() {
        return ResponseBuilder.newInstance().status(403, "Forbidden").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Forbidden", ""));
    }

    public static ResponseBuilder notFound() {
        return ResponseBuilder.newInstance().status(404, "Not Found").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("404 Page Not Found", ""));
    }

    public static ResponseBuilder forbidden(String message) {
        return ResponseBuilder.newInstance().status(403, "Forbidden").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Forbidden", message));
    }

    public static ResponseBuilder unauthorized(String message) {
        return ResponseBuilder.newInstance().status(401, "Unauthorized.").contentType("text/html;charset=UTF-8").body(Response.htmlMessage("Unauthorized.", message));
    }

    public static ResponseBuilder unauthorized() {
        return ResponseBuilder.newInstance().status(401, "Unauthorized.").contentType("text/html;charset=UTF-8").bodyEmpty();
    }

    @Override
    public String getStartLine() {
        StringBuilder buf = new StringBuilder();
        buf.append("HTTP/");
        buf.append(this.version);
        buf.append(" ");
        buf.append(this.statusCode);
        buf.append(" ");
        buf.append(this.statusMessage);
        buf.append("\r\n");
        return buf.toString();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Override
    public void parseStartLine(InputStream in) throws IOException, EndOfStreamException {
        String line;
        try {
            line = HttpUtil.readLine(in);
        }
        catch (EOFWhileReadingLineException e) {
            if (e.getLineSoFar().length() == 0) {
                throw new NoResponseException(e);
            }
            throw new EOFWhileReadingFirstLineException(e.getLineSoFar());
        }
        Matcher matcher = pattern.matcher(line);
        boolean find = matcher.find();
        if (!find) {
            throw new RuntimeException("Invalid server response: " + line);
        }
        this.version = matcher.group(1);
        this.statusCode = Integer.parseInt(matcher.group(2));
        this.statusMessage = matcher.group(4);
    }

    @Override
    public void read(InputStream in, boolean createBody) throws IOException, EndOfStreamException {
        this.parseStartLine(in);
        if (this.getStatusCode() == 100) {
            HttpUtil.readLine(in);
            return;
        }
        this.header = new Header(in);
        if (createBody) {
            this.createBody(in);
        }
    }

    @Override
    protected void createBody(InputStream in) throws IOException {
        if (this.isRedirect() && this.mayHaveNoBody()) {
            return;
        }
        if (this.isBodyEmpty()) {
            log.debug("empty body created");
            this.body = new EmptyBody();
            return;
        }
        super.createBody(in);
    }

    public boolean isRedirect() {
        return this.statusCode >= 300 && this.statusCode < 400;
    }

    public boolean hasNoContent() {
        return this.statusCode == 204;
    }

    @Override
    public String getName() {
        return " " + this.statusCode;
    }

    @Override
    public boolean isBodyEmpty() throws IOException {
        if (this.statusCode == 100 || this.statusCode == 101 || this.statusCode == 204 || this.statusCode == 205) {
            return true;
        }
        return super.isBodyEmpty();
    }

    public boolean isOk() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isUserError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isServerError() {
        return this.statusCode >= 500;
    }

    private boolean mayHaveNoBody() {
        if (this.header.isChunked()) {
            return false;
        }
        if (this.header.hasContentLength()) {
            return false;
        }
        return this.header.getContentType() == null;
    }

    @Override
    public boolean isKeepAlive() {
        if (this.isRedirect() && this.mayHaveNoBody()) {
            return false;
        }
        return super.isKeepAlive();
    }

    @Override
    public int estimateHeapSize() {
        return super.estimateHeapSize() + 12 + (this.statusMessage != null ? 2 * this.statusMessage.length() : 0);
    }

    @Override
    public <T extends Message> T createSnapshot() throws Exception {
        Response result = this.createMessageSnapshot(new Response());
        result.setStatusCode(this.getStatusCode());
        result.setStatusMessage(this.getStatusMessage());
        return (T)result;
    }

    public static class ResponseBuilder {
        private Response res = new Response();

        public Response build() {
            return this.res;
        }

        public ResponseBuilder status(int code, String msg) {
            this.res.setStatusCode(code);
            this.res.setStatusMessage(msg);
            return this;
        }

        public ResponseBuilder body(String msg) {
            this.res.setBodyContent(msg.getBytes(Constants.UTF_8_CHARSET));
            return this;
        }

        public ResponseBuilder body(byte[] body) {
            this.res.setBodyContent(body);
            return this;
        }

        public ResponseBuilder body(InputStream stream, boolean closeStreamWhenDone) throws IOException {
            this.res.getHeader().removeFields("Content-Length");
            this.res.getHeader().setValue("Transfer-Encoding", "chunked");
            Body b = new Body(stream);
            if (closeStreamWhenDone) {
                b.addObserver(new BodyCompleteMessageObserver(stream));
            }
            this.res.setBody(b);
            return this;
        }

        public ResponseBuilder bodyEmpty() {
            this.res.getHeader().setContentLength(0L);
            return this;
        }

        public ResponseBuilder header(Header header) {
            this.res.setHeader(header);
            return this;
        }

        public ResponseBuilder header(String k, String v) {
            this.res.getHeader().add(k, v);
            return this;
        }

        public ResponseBuilder contentType(String type) {
            this.res.getHeader().setContentType(type);
            return this;
        }

        public static ResponseBuilder newInstance() {
            return new ResponseBuilder();
        }

        public ResponseBuilder dontCache() {
            this.res.getHeader().setNoCacheResponseHeaders();
            return this;
        }

        private class BodyCompleteMessageObserver
        extends AbstractMessageObserver
        implements NonRelevantBodyObserver {
            private final InputStream stream;

            public BodyCompleteMessageObserver(InputStream stream) {
                this.stream = stream;
            }

            @Override
            public void bodyComplete(AbstractBody body) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    log.error("Could not close body stream.", (Throwable)e);
                }
            }
        }
    }
}

