/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="dispatching")
public class DispatchingInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)DispatchingInterceptor.class.getName());

    public DispatchingInterceptor() {
        this.name = "Dispatching Interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (exc.getRule() instanceof AbstractServiceProxy) {
            exc.getDestinations().add(DispatchingInterceptor.getForwardingDestination(exc));
            this.setSNIPropertyOnExchange(exc);
            return Outcome.CONTINUE;
        }
        exc.getDestinations().add(exc.getRequest().getUri());
        return Outcome.CONTINUE;
    }

    private void setSNIPropertyOnExchange(Exchange exc) {
        String sni;
        AbstractServiceProxy asp = (AbstractServiceProxy)exc.getRule();
        if (asp.getTargetSSL() != null && (sni = asp.getTargetSSL().getServerName()) != null) {
            exc.setProperty("SNI_SERVER_NAME", sni);
        }
    }

    public static String getForwardingDestination(Exchange exc) throws Exception {
        AbstractServiceProxy p = (AbstractServiceProxy)exc.getRule();
        if (p.getTargetURL() != null) {
            log.debug("destination: " + p.getTargetURL());
            return p.getTargetURL();
        }
        if (p.getTargetHost() != null) {
            String url = new URL(p.getTargetScheme(), p.getTargetHost(), p.getTargetPort(), exc.getRequest().getUri()).toString();
            log.debug("destination: " + url);
            return url;
        }
        return exc.getRequest().getUri();
    }
}

