/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apimanagement;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.interceptor.apimanagement.Key;
import com.predic8.membrane.core.interceptor.apimanagement.policy.Policy;
import com.predic8.membrane.core.interceptor.apimanagement.policy.Quota;
import com.predic8.membrane.core.interceptor.apimanagement.policy.RateLimit;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.util.functionalInterfaces.Consumer;
import com.predic8.membrane.core.util.functionalInterfaces.Function;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ApiManagementConfiguration {
    private static String currentDir;
    private static Logger log;
    private ResolverMap resolver = null;
    private String location = null;
    private String hashLocation = null;
    private String currentHash = "";
    private ApplicationContext context;
    public HashSet<Runnable> configChangeObservers = new HashSet();
    String etcdPathPrefix = "/membrane/";
    private String membraneName;
    private boolean contextLost = false;
    private Thread etcdConfigFingerprintLongPollThread;
    private Map<String, Policy> policies = new ConcurrentHashMap<String, Policy>();
    private Map<String, Key> keys = new ConcurrentHashMap<String, Key>();
    public static final String DEFAULT_RESOLVER_NAME = "resolverMap";

    private void notifyConfigChangeObservers() {
        for (Runnable runner : this.configChangeObservers) {
            runner.run();
        }
    }

    public static String getCurrentDir() {
        return currentDir;
    }

    public static void setCurrentDir(String currentDir) {
        ApiManagementConfiguration.currentDir = currentDir;
    }

    public Map<String, Policy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Map<String, Policy> policies) {
        this.policies = policies;
    }

    public Map<String, Key> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, Key> keys) {
        this.keys = keys;
    }

    public ApiManagementConfiguration() {
        this(System.getProperty("user.dir"), "api.yaml", "membrane");
    }

    public ApiManagementConfiguration(String currentDir, String configLocation) {
        this(currentDir, configLocation, "");
    }

    public ApiManagementConfiguration(String currentDir, String configLocation, String membraneName) {
        if (this.getResolver() == null) {
            this.setResolver(new ResolverMap());
        }
        ApiManagementConfiguration.setCurrentDir(currentDir);
        this.setMembraneName(membraneName);
        this.setLocation(configLocation);
        try {
            this.updateAfterLocationChange();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Policy> parsePolicies(Map<String, Object> yaml) {
        HashMap<String, Policy> result = new HashMap<String, Policy>();
        Object policies = yaml.get("policies");
        if (policies == null) {
            log.warn("No policies in policy file");
            return result;
        }
        List yamlPolicies = (List)policies;
        for (Object yamlPolicyObj : yamlPolicies) {
            if (yamlPolicyObj == null) continue;
            LinkedHashMap yamlPolicy = (LinkedHashMap)yamlPolicyObj;
            for (Object polObj : yamlPolicy.values()) {
                Object quotaObj;
                if (polObj == null) continue;
                LinkedHashMap yamlPolicyDef = (LinkedHashMap)polObj;
                Policy policy = new Policy();
                Object name = yamlPolicyDef.get("id");
                if (name == null) {
                    log.warn("Policy object found, but no \"id\" field");
                    continue;
                }
                String policyName = (String)name;
                policy.setName(policyName);
                Object serviceProxiesObj = yamlPolicyDef.get("serviceProxy");
                if (serviceProxiesObj == null) {
                    log.warn("Policy object found, but no service proxies specified ");
                    continue;
                }
                List serviceProxyNames = (List)serviceProxiesObj;
                for (String sp : serviceProxyNames) {
                    policy.getServiceProxies().add(sp);
                }
                Object rateLimitObj = yamlPolicyDef.get("rateLimit");
                if (rateLimitObj != null) {
                    LinkedHashMap rateLimitData = (LinkedHashMap)rateLimitObj;
                    RateLimit rateLimit = new RateLimit();
                    int requests = this.parseInteger(rateLimitData.get("requests"), 1000);
                    int interval = this.parseInteger(rateLimitData.get("interval"), 3600);
                    rateLimit.setRequests(requests);
                    rateLimit.setInterval(interval);
                    policy.setRateLimit(rateLimit);
                }
                if ((quotaObj = yamlPolicyDef.get("quota")) != null) {
                    LinkedHashMap quota = (LinkedHashMap)quotaObj;
                    Object quotaSizeObj = quota.get("size");
                    long quotaNumber = this.getQuotaNumber(quotaSizeObj);
                    int quotaInterval = this.parseInteger(quota.get("interval"), Quota.INTERVAL_DEFAULT);
                    Quota q = new Quota();
                    q.setSize(quotaNumber);
                    q.setInterval(quotaInterval);
                    policy.setQuota(q);
                }
                this.parseUnauthenticatedField(yamlPolicyDef, policy);
                result.put(policyName, policy);
            }
        }
        return result;
    }

    private void parseUnauthenticatedField(LinkedHashMap<String, Object> yamlPolicyDef, Policy policy) {
        policy.setUnauthenticated(this.parseBoolean(yamlPolicyDef.get("unauthenticated"), false));
    }

    private <T> T StringToTypeConverter(Object obj, T defObj, Function<String, T> stringToTypeConverter) {
        if (obj == null) {
            return defObj;
        }
        if (obj instanceof String) {
            if (((String)obj).isEmpty()) {
                return defObj;
            }
            return stringToTypeConverter.call((String)obj);
        }
        try {
            return (T)obj;
        }
        catch (Exception ignored2) {
            log.error("Could not parse policies file. Please make sure that the file is valid.");
            return defObj;
        }
    }

    private String parseString(Object obj, String defObj) {
        return this.StringToTypeConverter(obj, defObj, value -> value);
    }

    private boolean parseBoolean(Object obj, Boolean defObj) {
        return this.StringToTypeConverter(obj, defObj, value -> Boolean.parseBoolean(value));
    }

    private long getQuotaNumber(Object quotaSizeObj) {
        long quotaNumber = 0L;
        String quotaSymbolString = "";
        if (quotaSizeObj == null) {
            log.warn("Quota object found, but size field is empty");
            quotaNumber = Quota.SIZE_DEFAULT;
        } else {
            try {
                String quotaString = (String)quotaSizeObj;
                quotaNumber = NumberFormat.getInstance().parse(quotaString).intValue();
                quotaSymbolString = quotaString.replaceFirst(Long.toString(quotaNumber), "").toLowerCase();
            }
            catch (ParseException ignored) {
                quotaNumber = Quota.SIZE_DEFAULT;
            }
        }
        if (quotaSymbolString.length() > 0) {
            switch (quotaSymbolString) {
                case "gb": 
                case "g": {
                    quotaNumber *= 1024L;
                }
                case "mb": 
                case "m": {
                    quotaNumber *= 1024L;
                }
                case "kb": 
                case "k": {
                    quotaNumber *= 1024L;
                }
            }
        }
        return quotaNumber;
    }

    private int parseInteger(Object obj, int defaultValue) {
        return this.StringToTypeConverter(obj, defaultValue, value -> Integer.parseInt(value));
    }

    private void parseAndConstructConfiguration(InputStream is) throws IOException {
        String yamlSource = null;
        try {
            yamlSource = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            log.warn("Could not read stream");
            return;
        }
        YAMLMapper mapper = new YAMLMapper();
        Map yaml = null;
        try {
            yaml = (Map)mapper.readValue(yamlSource, Map.class);
        }
        catch (IOException e) {
            log.warn("Could not parse yaml");
            return;
        }
        this.setPolicies(this.parsePolicies(yaml));
        this.setKeys(this.parsePoliciesForKeys(yaml));
        is.close();
        log.info("Configuration loaded. Notifying observers");
        this.notifyConfigChangeObservers();
    }

    public HashSet<Policy> getUnauthenticatedPolicies() {
        HashSet<Policy> result = new HashSet<Policy>();
        for (Policy p : this.getPolicies().values()) {
            if (!p.isUnauthenticated()) continue;
            result.add(p);
        }
        return result;
    }

    public void addIpAsApiKeyIfNeeded(String ip) {
        if (!this.getKeys().containsKey(ip)) {
            Key key = new Key();
            key.setName(ip);
            key.setExpiration(null);
            key.setPolicies(this.getUnauthenticatedPolicies());
            this.getKeys().put(ip, key);
        }
    }

    private Map<String, Key> parsePoliciesForKeys(Map<String, Object> yaml) {
        HashMap<String, Key> result = new HashMap<String, Key>();
        List keys = (List)yaml.get("keys");
        if (keys == null) {
            log.info("No API keys in policy file");
            return result;
        }
        for (Object keyObject : keys) {
            LinkedHashMap key = (LinkedHashMap)keyObject;
            Key keyRes = new Key();
            String keyName = (String)key.get("key");
            keyRes.setName(keyName);
            this.parseExpiration(key, keyRes);
            List policiesForKey = (List)key.get("policies");
            HashSet<Policy> policies = new HashSet<Policy>();
            for (Object polObj : policiesForKey) {
                String policyName = (String)polObj;
                Policy p = this.policies.get(policyName);
                policies.add(p);
            }
            keyRes.setPolicies(policies);
            result.put(keyName, keyRes);
        }
        return result;
    }

    private void parseExpiration(LinkedHashMap<String, Object> keyYaml, Key key) {
        String expirationString = this.parseString(keyYaml.get("expires"), null);
        Instant expiration = null;
        if (expirationString != null) {
            try {
                expiration = Instant.parse(expirationString);
            }
            catch (Exception e) {
                log.error("Could not read expiration");
            }
        }
        key.setExpiration(expiration);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private boolean isLocalFile(String location) {
        boolean isFile = false;
        try {
            URI uri = new URI(location);
            if (uri.getScheme() == null || uri.getScheme().equals("file")) {
                isFile = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return isFile;
    }

    public void updateAfterLocationChange() throws IOException {
        if (!this.isLocalFile(this.location)) {
            log.info("Loading configuration from [" + this.location + "]");
            if (this.location.startsWith("etcd")) {
                this.handleEtcd(this.location);
            } else {
                try {
                    this.parseAndConstructConfiguration(this.getResolver().resolve(this.location));
                }
                catch (ResourceRetrievalException e) {
                    log.error("Could not retrieve resource");
                    return;
                }
            }
            return;
        }
        if (this.location.isEmpty()) {
            this.location = "api.yaml";
        }
        final String newLocation = ResolverMap.combine(ApiManagementConfiguration.getCurrentDir(), this.location);
        log.info("Loading configuration from [" + newLocation + "]");
        InputStream is = null;
        try {
            is = this.getResolver().resolve(newLocation);
        }
        catch (ResourceRetrievalException e) {
            log.error("Could not retrieve resource");
            return;
        }
        this.parseAndConstructConfiguration(is);
        try {
            this.getResolver().observeChange(newLocation, new Consumer<InputStream>(){

                @Override
                public void call(InputStream inputStream) {
                    log.info("Loading configuration from [" + newLocation + "]");
                    if (!ApiManagementConfiguration.this.getContextLost()) {
                        try {
                            ApiManagementConfiguration.this.parseAndConstructConfiguration(inputStream);
                            ApiManagementConfiguration.this.getResolver().observeChange(newLocation, this);
                        }
                        catch (ResourceRetrievalException resourceRetrievalException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (Exception warn) {
            URL url = null;
            try {
                url = new URL(newLocation);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            String schema = "";
            if (url != null) {
                schema = url.getProtocol();
            }
            log.warn("Could not observe AMC location for " + schema);
        }
    }

    private void handleEtcd(String location) throws IOException {
        String baseKey;
        final String etcdLocation = location.substring(7);
        EtcdResponse respGetConfigUrl = EtcdRequest.create(etcdLocation, baseKey = this.etcdPathPrefix + this.getMembraneName(), "/apiconfig").getValue("url").sendRequest();
        if (!respGetConfigUrl.is2XX()) {
            log.warn("Could not get config url at " + etcdLocation + baseKey + "/apiconfig");
            return;
        }
        String configLocation = respGetConfigUrl.getValue();
        this.setLocation(configLocation);
        this.updateAfterLocationChange();
        this.setLocation(location);
        if (this.etcdConfigFingerprintLongPollThread == null) {
            this.etcdConfigFingerprintLongPollThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!ApiManagementConfiguration.this.getContextLost()) {
                            if (!EtcdRequest.create(etcdLocation, baseKey, "/apiconfig").getValue("fingerprint").longPoll().sendRequest().is2XX()) {
                                log.warn("Could not get config fingerprint at " + etcdLocation);
                            }
                            if (ApiManagementConfiguration.this.getContextLost()) continue;
                            log.info("Noticed configuration change, updating...");
                            ApiManagementConfiguration.this.updateAfterLocationChange();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.etcdConfigFingerprintLongPollThread.start();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void start() {
        try {
            if (this.getResolver() == null) {
                Object defaultResolver = null;
                try {
                    if (this.context != null) {
                        defaultResolver = this.context.getBean(DEFAULT_RESOLVER_NAME);
                        if (defaultResolver != null) {
                            this.setResolver((ResolverMap)defaultResolver);
                        }
                    } else {
                        log.error("Context not set");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getResolver() == null) {
                    this.setResolver(new ResolverMap());
                }
            }
            if (this.hashLocation == null) {
                this.updateAfterLocationChange();
            } else {
                this.setHashLocation(this.hashLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    public ResolverMap getResolver() {
        return this.resolver;
    }

    public void setResolver(ResolverMap resolver) {
        this.resolver = resolver;
    }

    public String getHashLocation() {
        return this.hashLocation;
    }

    public void setHashLocation(String hashLocation) throws IOException {
        this.hashLocation = hashLocation;
    }

    public void setMembraneName(String membraneName) {
        this.membraneName = membraneName;
    }

    public String getMembraneName() {
        return this.membraneName;
    }

    public boolean getContextLost() {
        return this.contextLost;
    }

    public void setContextLost(boolean contextLost) {
        this.contextLost = contextLost;
    }

    public void shutdown() {
        this.setContextLost(true);
    }

    static {
        log = LoggerFactory.getLogger(ApiManagementConfiguration.class);
    }
}

