/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.cbr;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.AbstractXmlElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="case", topLevel=false, id="switch-case")
public class Case
extends AbstractXmlElement {
    private String url;
    private String xPath;

    public Case() {
    }

    public Case(String xPath, String url) {
        this.url = url;
        this.xPath = xPath;
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    public String getService() {
        if (this.url.startsWith("service:")) {
            return this.url.substring(8);
        }
        return null;
    }

    @MCAttribute
    public void setService(String service) {
        this.url = "service:" + service;
    }

    public String getxPath() {
        return this.xPath;
    }

    @Required
    @MCAttribute
    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("case");
        out.writeAttribute("xPath", this.xPath);
        out.writeAttribute("url", this.url);
        out.writeEndElement();
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
        this.xPath = token.getAttributeValue("", "xPath");
        this.url = token.getAttributeValue("", "url");
        if (token.getAttributeValue("", "service") != null) {
            this.url = "service:" + token.getAttributeValue("", "service");
        }
    }
}

