/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="request", topLevel=false)
public class RequestInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);

    public RequestInterceptor() {
        this.name = "Request Interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        boolean logDebug = log.isDebugEnabled();
        for (Interceptor i : this.getInterceptors()) {
            Outcome o;
            EnumSet<Interceptor.Flow> f = i.getFlow();
            if (!f.contains((Object)Interceptor.Flow.REQUEST)) continue;
            if (logDebug) {
                log.debug("Invoking request handler: " + i.getDisplayName() + " on exchange: " + exc);
            }
            if ((o = i.handleRequest(exc)) == Outcome.CONTINUE) continue;
            return o;
        }
        return Outcome.CONTINUE;
    }
}

