/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.google.common.base.Function;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="groovy", mixed=true)
public class GroovyInterceptor
extends AbstractInterceptor {
    Logger log = LoggerFactory.getLogger(GroovyInterceptor.class);
    private String src = "";
    private Function<Map<String, Object>, Object> script;

    public GroovyInterceptor() {
        this.name = "Groovy";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.runScript(exc, Interceptor.Flow.RESPONSE);
    }

    @Override
    public void handleAbort(Exchange exc) {
        try {
            this.runScript(exc, Interceptor.Flow.ABORT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void init() {
        if (this.router == null) {
            return;
        }
        if ("".equals(this.src)) {
            return;
        }
        try {
            this.script = new GroovyLanguageSupport().compileScript(this.router, this.src);
        }
        catch (MultipleCompilationErrorsException e) {
            this.logGroovyException(null, (Exception)((Object)e));
            throw new RuntimeException(e);
        }
    }

    private Outcome runScript(Exchange exc, Interceptor.Flow flow) throws InterruptedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("exc", exc);
        parameters.put("flow", (Object)flow);
        Object res = null;
        try {
            res = this.script.apply(parameters);
        }
        catch (Exception e) {
            this.logGroovyException(flow, e);
            return Outcome.ABORT;
        }
        if (res instanceof Outcome) {
            return (Outcome)((Object)res);
        }
        if (res instanceof Response) {
            exc.setResponse((Response)res);
            return Outcome.RETURN;
        }
        if (res instanceof Request) {
            exc.setRequest((Request)res);
        }
        return Outcome.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logGroovyException(Interceptor.Flow flow, Exception e) {
        try {
            ServiceProxy sp = (ServiceProxy)this.getRule();
            this.log.error("Exception in Groovy script in service proxy '" + sp.getName() + "' on port " + sp.getPort() + " with path " + (sp.getPath() != null ? sp.getPath().getValue() : "*"));
            if (flow != null) {
                this.log.error("Flow: " + flow.name());
            } else {
                this.log.error("There is possibly a syntax error in the groovy script (compilation error)");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            e.printStackTrace();
        }
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public String getShortDescription() {
        return "Executes a groovy script.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(TextUtil.removeFinalChar(this.getShortDescription()));
        sb.append(":<br/><pre style=\"overflow-x:auto\">");
        sb.append(StringEscapeUtils.escapeHtml((String)TextUtil.removeCommonLeadingIndentation(this.src)));
        sb.append("</pre>");
        return sb.toString();
    }
}

