/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.util.functionalInterfaces.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="claims")
public class ClaimList {
    private List<Scope> scopes = new ArrayList<Scope>();
    HashMap<String, HashSet<String>> scopesToClaims = new HashMap();
    private String value;
    private HashSet<String> supportedClaims = new HashSet();

    public HashSet<String> getSupportedClaims() {
        return this.supportedClaims;
    }

    public void setSupportedClaims(HashSet<String> supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public void init(Router router) {
        this.setScopes(this.scopes);
    }

    public String getSupportedScopes() {
        return this.toString(this.scopes);
    }

    public String getSupportedClaimsAsString() {
        return this.toString(this.supportedClaims);
    }

    public HashSet<String> getValidClaims(String claimsToCheck) {
        String[] split;
        HashSet<String> result = new HashSet<String>();
        for (String providedClaim : split = claimsToCheck.split(" ")) {
            if (!this.getSupportedClaims().contains(providedClaim)) continue;
            result.add(providedClaim);
        }
        return result;
    }

    public Map<String, String> getClaimsFromSession(Map<String, String> sessionProperties, HashSet<String> claims) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String claim : claims) {
            result.put(claim, sessionProperties.get(claim));
        }
        return result;
    }

    public HashSet<String> getClaimsForScope(String scope) {
        return this.scopesToClaims.get(scope);
    }

    private <T> String toString(Iterable<T> iterable, Function<T, String> fun) {
        StringBuilder builder = new StringBuilder();
        for (T element : iterable) {
            builder.append(" ").append(fun.call(element));
        }
        return builder.toString().trim();
    }

    private <T> String toString(Iterable<T> iterable) {
        return this.toString(iterable, new Function<T, String>(){

            @Override
            public String call(T param) {
                return param.toString();
            }
        });
    }

    private String toString(List<Scope> scopes) {
        return this.toString(scopes, new Function<Scope, String>(){

            @Override
            public String call(Scope param) {
                return param.getId();
            }
        });
    }

    public boolean scopeExists(String s) {
        return this.scopesToClaims.containsKey(s);
    }

    public String getValue() {
        return this.value;
    }

    @Required
    @MCAttribute
    public void setValue(String value) {
        this.value = value;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    @MCChildElement(order=1)
    public void setScopes(List<Scope> scopes) {
        this.createSupportedClaims();
        this.addOpenidScope(scopes);
        this.scopesToClaims.clear();
        for (Scope scope : scopes) {
            this.scopesToClaims.put(scope.id, this.getValidClaims(scope.getClaims()));
            scope.setClaims(this.toString(this.getValidClaims(scope.getClaims())));
        }
        this.scopes = scopes;
    }

    private void addOpenidScope(List<Scope> scopes) {
        for (Scope scope : scopes) {
            if (!scope.id.equals("openid")) continue;
            return;
        }
        scopes.add(new Scope("openid", ""));
    }

    private void createSupportedClaims() {
        this.setSupportedClaims(new HashSet<String>(Arrays.asList(this.value.split(" "))));
    }

    @MCElement(name="scope", topLevel=false, id="claims-scope")
    public static class Scope {
        private String id;
        private String claims;

        public Scope() {
        }

        public Scope(String id, String claims) {
            this.id = id;
            this.claims = claims;
        }

        public String getId() {
            return this.id;
        }

        @Required
        @MCAttribute
        public void setId(String id) {
            this.id = id;
        }

        public String getClaims() {
            return this.claims;
        }

        @Required
        @MCAttribute
        public void setClaims(String claims) {
            this.claims = claims;
        }
    }
}

