/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.ClientList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

@MCElement(name="staticClientList")
public class StaticClientList
implements ClientList {
    private HashMap<String, Client> clientIdsToClients = new HashMap();
    private List<Client> clients = new ArrayList<Client>();

    @Override
    public void init(Router router) {
        this.setClients(this.clients);
    }

    @Override
    public Client getClient(String clientId) {
        if (!this.clientIdsToClients.containsKey(clientId)) {
            throw new NoSuchElementException();
        }
        return this.clientIdsToClients.get(clientId);
    }

    public List<Client> getClients() {
        return this.clients;
    }

    @MCChildElement
    public void setClients(List<Client> clients) {
        this.clients = clients;
        this.clientIdsToClients.clear();
        for (Client c : clients) {
            this.clientIdsToClients.put(c.getClientId(), c);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Client c : this.clientIdsToClients.values()) {
            builder.append(c.getClientId()).append("\n");
        }
        return builder.toString();
    }
}

