/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.ReusableJsonGenerator;
import com.predic8.membrane.core.interceptor.oauth2.TokenAuthorizationHeader;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.ParameterizedRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class UserinfoRequest
extends ParameterizedRequest {
    private TokenAuthorizationHeader authHeader;
    private HashMap<String, String> sessionProperties;

    public UserinfoRequest(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        this.authHeader = new TokenAuthorizationHeader(this.exc.getRequest());
        if (!this.authHeader.isSet()) {
            return this.buildWwwAuthenticateErrorResponse(Response.badRequest(), "invalid_request");
        }
        return new NoResponse();
    }

    @Override
    protected Response processWithParameters() throws Exception {
        if (!this.authHeader.isValid() || !this.authServer.getSessionFinder().hasSessionForToken(this.authHeader.getToken())) {
            return this.buildWwwAuthenticateErrorResponse(Response.unauthorized(), "invalid_token");
        }
        this.sessionProperties = new HashMap<String, String>(this.authServer.getSessionFinder().getSessionForToken(this.authHeader.getToken()).getUserAttributes());
        String token = this.authHeader.getToken();
        String username = this.authServer.getTokenGenerator().getUsername(token);
        return new NoResponse();
    }

    @Override
    protected Response getResponse() throws Exception {
        return Response.ok().body(this.getUserDataAsJson(this.sessionProperties)).contentType("application/json;charset=utf-8").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserDataAsJson(Map<String, String> sessionProperties) throws IOException {
        HashMap<String, String> claims = new HashMap<String, String>();
        if (sessionProperties.get("scope") != null) {
            if (OAuth2Util.isOpenIdScope(sessionProperties.get("scope"))) {
                claims.putAll(this.getClaimsFromClaimsParameter(sessionProperties));
            }
            claims.putAll(this.getClaimsFromScopes(sessionProperties));
        }
        ReusableJsonGenerator reusableJsonGenerator = this.jsonGen;
        synchronized (reusableJsonGenerator) {
            JsonGenerator gen = this.jsonGen.resetAndGet();
            gen.writeStartObject();
            for (String property : claims.keySet()) {
                gen.writeObjectField(property, claims.get(property));
            }
            gen.writeEndObject();
            return this.jsonGen.getJson();
        }
    }

    private Map<String, String> getClaimsFromClaimsParameter(Map<String, String> sessionProperties) {
        ClaimsParameter cp = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), sessionProperties.get("claims"));
        return this.authServer.getClaimList().getClaimsFromSession(sessionProperties, cp.getUserinfoClaims());
    }

    private Map<String, String> getClaimsFromScopes(Map<String, String> sessionProperties) {
        String[] scopes = sessionProperties.get("scope").split(" ");
        HashSet<String> claims = new HashSet<String>();
        for (String scope : scopes) {
            claims.addAll(this.authServer.getClaimList().getClaimsForScope(scope));
        }
        return this.authServer.getClaimList().getClaimsFromSession(sessionProperties, claims);
    }
}

