/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.tokenrequest.TokenRequest;
import java.util.NoSuchElementException;

public class RefreshTokenFlow
extends TokenRequest {
    public RefreshTokenFlow(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getRefreshToken() == null || this.getClientId() == null || this.getClientSecret() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        return new NoResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response processWithParameters() throws Exception {
        SessionManager.Session session;
        String username;
        if (!this.verifyClientThroughParams()) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "unauthorized_client");
        }
        try {
            username = this.authServer.getRefreshTokenGenerator().getUsername(this.getRefreshToken());
        }
        catch (NoSuchElementException ex) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        this.params.put("username", username);
        try {
            this.authServer.getRefreshTokenGenerator().invalidateToken(this.getRefreshToken(), this.getClientId(), this.getClientSecret());
        }
        catch (NoSuchElementException ex) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_grant");
        }
        this.scope = this.getScope();
        this.idToken = null;
        this.token = this.authServer.getTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret());
        this.refreshToken = this.authServer.getRefreshTokenGenerator().getToken(this.getUsername(), this.getClientId(), this.getClientSecret());
        SessionManager.Session session2 = session = this.getSessionForAuthorizedUserWithParams();
        synchronized (session2) {
            session.getUserAttributes().put("access_token", this.token);
        }
        this.authServer.getSessionFinder().addSessionForToken(this.token, session);
        return new NoResponse();
    }

    @Override
    protected Response getResponse() throws Exception {
        return Response.ok().body(this.getTokenJSONResponse()).contentType("application/json;charset=utf-8").dontCache().build();
    }
}

