/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.tokengenerators;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.transport.http.HttpClient;
import java.math.BigInteger;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;

public class JwtGenerator {
    private SecureRandom random = new SecureRandom();
    private RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);

    public String getJwk() {
        return "{\"keys\": [ " + this.rsaJsonWebKey.toJson() + "]}";
    }

    public JwtGenerator() throws JoseException {
        this.rsaJsonWebKey.setKeyId(new BigInteger(130, this.random).toString(32));
        this.rsaJsonWebKey.setUse("sig");
        this.rsaJsonWebKey.setAlgorithm("RS256");
    }

    public String getSignedIdToken(String iss, String sub, String aud, int expirationInSeconds, Claim ... additionalClaims) throws JoseException {
        return this.getSignedToken(this.addNonDefaultClaims(this.getDefaultClaims(iss, sub, aud, expirationInSeconds), additionalClaims));
    }

    private String getSignedToken(JwtClaims claims) throws JoseException {
        return this.prepareClaimsSigning(claims).getCompactSerialization();
    }

    private JsonWebSignature prepareClaimsSigning(JwtClaims claims) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey((Key)this.rsaJsonWebKey.getPrivateKey());
        jws.setKeyIdHeaderValue(this.rsaJsonWebKey.getKeyId());
        jws.setHeader("typ", "JWT");
        jws.setAlgorithmHeaderValue("RS256");
        return jws;
    }

    private JwtClaims addNonDefaultClaims(JwtClaims claims, Claim[] additionalClaims) {
        for (Claim claim : additionalClaims) {
            claims.setClaim(claim.getName(), (Object)claim.getValue());
        }
        return claims;
    }

    private JwtClaims getDefaultClaims(String iss, String sub, String aud, float expirationInSeconds) {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(iss);
        claims.setSubject(sub);
        claims.setAudience(aud);
        claims.setExpirationTimeMinutesInTheFuture(expirationInSeconds / 60.0f);
        claims.setIssuedAtToNow();
        claims.setGeneratedJwtId();
        claims.setNotBeforeMinutesInThePast(2.0f);
        return claims;
    }

    public List<Claim> getClaimsFromSignedIdToken(String idToken, String iss, String aud) throws InvalidJwtException {
        ArrayList<Claim> result = new ArrayList<Claim>();
        JwtClaims claims = this.processIdTokenToClaims(idToken, iss, aud);
        for (String claim : claims.getClaimsMap().keySet()) {
            result.add(new Claim(claim, String.valueOf(claims.getClaimValue(claim))));
        }
        return result;
    }

    public static List<Claim> getClaimsFromSignedIdToken(String idToken, String iss, String aud, Key key) throws InvalidJwtException {
        JwtClaims claims = JwtGenerator.processIdTokenToClaims(idToken, iss, aud, key);
        return JwtGenerator.getClaimsFromClaimsMap(claims);
    }

    public static List<Claim> getClaimsFromSignedIdToken(String idToken, String iss, String aud, VerificationKeyResolver resolver) throws InvalidJwtException {
        JwtClaims claims = JwtGenerator.processIdTokenToClaims(idToken, iss, aud, resolver);
        return JwtGenerator.getClaimsFromClaimsMap(claims);
    }

    public static List<Claim> getClaimsFromSignedIdToken(String idToken, String iss, String aud, String jwksUrl) throws InvalidJwtException {
        JwtClaims claims = JwtGenerator.processIdTokenToClaims(idToken, iss, aud, (VerificationKeyResolver)new HttpsJwksVerificationKeyResolver(new HttpsJwks(jwksUrl)));
        return JwtGenerator.getClaimsFromClaimsMap(claims);
    }

    public static List<Claim> getClaimsFromSignedIdToken(String idToken, String iss, String aud, String jwksUrl, HttpClient hc) throws Exception {
        Exchange getJwks = new Request.Builder().get(jwksUrl).buildExchange();
        JwtClaims claims = JwtGenerator.processIdTokenToClaims(idToken, iss, aud, (VerificationKeyResolver)new JwksVerificationKeyResolver(new JsonWebKeySet(hc.call(getJwks).getResponse().getBodyAsStringDecoded()).getJsonWebKeys()));
        return JwtGenerator.getClaimsFromClaimsMap(claims);
    }

    private static List<Claim> getClaimsFromClaimsMap(JwtClaims claims) {
        ArrayList<Claim> result = new ArrayList<Claim>();
        for (String claim : claims.getClaimsMap().keySet()) {
            result.add(new Claim(claim, String.valueOf(claims.getClaimValue(claim))));
        }
        return result;
    }

    private JwtClaims processIdTokenToClaims(String idToken, String iss, String aud) throws InvalidJwtException {
        return JwtGenerator.processIdTokenToClaims(idToken, iss, aud, this.rsaJsonWebKey.getKey());
    }

    private static JwtClaims processIdTokenToClaims(String idToken, String iss, String aud, Key key) throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedIssuer(iss).setExpectedAudience(new String[]{aud}).setVerificationKey(key).build();
        return jwtConsumer.processToClaims(idToken);
    }

    private static JwtClaims processIdTokenToClaims(String idToken, String iss, String aud, VerificationKeyResolver resolver) throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(30).setRequireSubject().setExpectedIssuer(iss).setExpectedAudience(new String[]{aud}).setVerificationKeyResolver(resolver).build();
        return jwtConsumer.processToClaims(idToken);
    }

    public static class Claim {
        private String name;
        private String value;

        public Claim(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

