/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.prometheus;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.StatisticCollector;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="prometheus")
public class PrometheusInterceptor
extends AbstractInterceptor {
    static final Logger LOG = LoggerFactory.getLogger(PrometheusInterceptor.class);
    static volatile boolean issuedDuplicateRuleNameWarning = false;
    ConcurrentHashMap<String, String> names = new ConcurrentHashMap();
    Pattern ILLEGAL_FIRST_CHAR = Pattern.compile("^[^a-zA-Z_:]");
    Pattern ILLEGAL_CHARS = Pattern.compile("[^a-zA-Z0-9_:]");

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        Context ctx = new Context();
        this.buildPrometheusStyleResponse(ctx);
        exc.setResponse(Response.ok(ctx.sb.toString()).header("Content-Type", "text/plain; version=0.0.4").build());
        return Outcome.RETURN;
    }

    private void buildPrometheusStyleResponse(Context ctx) {
        ctx.resetAll();
        ctx.reset();
        for (Rule r : this.router.getRuleManager().getRules()) {
            if (!ctx.seenRules.add(this.prometheusCompatibleName(r.getName()))) {
                if (issuedDuplicateRuleNameWarning) continue;
                LOG.warn("The prometheus interceptor detected the same rule name more than once: " + r.getName());
                issuedDuplicateRuleNameWarning = true;
                continue;
            }
            this.buildStatuscodeLines(ctx, r);
        }
        ctx.collect();
    }

    private void buildStatuscodeLines(Context ctx, Rule rule) {
        Map<Integer, StatisticCollector> stats = rule.getStatisticCollector().getStatisticsByStatusCodes();
        for (Integer code : stats.keySet()) {
            this.buildLine(ctx.s1, rule.getName(), stats.get(code).getCount(), "code", code, "count");
            this.buildLine(ctx.s2, rule.getName(), stats.get(code).getGoodCount(), "code", code, "good_count");
            this.buildLine(ctx.s3, rule.getName(), stats.get(code).getGoodTotalTime(), "code", code, "good_time");
            this.buildLine(ctx.s4, rule.getName(), stats.get(code).getGoodTotalBytesSent(), "code", code, "good_bytes_req_body");
            this.buildLine(ctx.s5, rule.getName(), stats.get(code).getGoodTotalBytesReceived(), "code", code, "good_bytes_res_body");
        }
    }

    private StringBuilder buildLine(StringBuilder sb, String ruleName, long value, String labelName, int labelValue, String postFix) {
        String prometheusName = this.prometheusCompatibleName("membrane_" + postFix);
        if (sb.length() == 0) {
            sb.append("# TYPE " + prometheusName + " counter\n");
        }
        sb.append(prometheusName);
        sb.append("{rule=\"");
        sb.append(this.prometheusCompatibleName(ruleName));
        sb.append("\",");
        sb.append(this.prometheusCompatibleName(labelName));
        sb.append("=\"");
        sb.append(labelValue);
        sb.append("\"} ");
        sb.append(value);
        sb.append("\n");
        return sb;
    }

    private String prometheusCompatibleName(String name) {
        String result = this.names.get(name);
        if (result != null) {
            return result;
        }
        result = this.prettyPrint(name);
        result = this.ILLEGAL_CHARS.matcher(result).replaceAll("_");
        result = this.ILLEGAL_FIRST_CHAR.matcher(result).replaceAll("_");
        this.names.put(name, result);
        return result;
    }

    private String prettyPrint(String ruleName) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String s : split = ruleName.toLowerCase().split(" ")) {
            sb.append(s).append("_");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private class Context {
        StringBuilder sb = new StringBuilder();
        StringBuilder s1 = new StringBuilder();
        StringBuilder s2 = new StringBuilder();
        StringBuilder s3 = new StringBuilder();
        StringBuilder s4 = new StringBuilder();
        StringBuilder s5 = new StringBuilder();
        HashSet<String> seenRules = new HashSet();

        private Context() {
        }

        private void reset() {
            this.s1.setLength(0);
            this.s2.setLength(0);
            this.s3.setLength(0);
            this.s4.setLength(0);
            this.s5.setLength(0);
        }

        private void resetAll() {
            this.sb.setLength(0);
            this.seenRules.clear();
        }

        private void collect() {
            this.sb.append((CharSequence)this.s1);
            this.sb.append((CharSequence)this.s2);
            this.sb.append((CharSequence)this.s3);
            this.sb.append((CharSequence)this.s4);
            this.sb.append((CharSequence)this.s5);
        }
    }
}

