/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.jmx;

import com.predic8.membrane.annot.MCElement;
import java.util.HashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.support.RegistrationPolicy;

@MCElement(name="jmxExporter")
public class JmxExporter
extends MBeanExporter
implements Lifecycle,
ApplicationContextAware,
DisposableBean {
    public static final String JMX_EXPORTER_NAME = "jmxExporter";
    HashMap<String, Object> jmxBeans = new HashMap();
    ApplicationContext context;
    MBeanExporter exporter;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void start() {
        this.exporter = new MBeanExporter();
        this.exporter.setRegistrationPolicy(RegistrationPolicy.IGNORE_EXISTING);
        MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler();
        assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
        assembler.afterPropertiesSet();
        this.exporter.setAssembler((MBeanInfoAssembler)assembler);
    }

    public void stop() {
    }

    public boolean isRunning() {
        return false;
    }

    public void destroy() {
        this.jmxBeans.clear();
        this.exporter.destroy();
    }

    public void addBean(String fullyQualifiedMBeanName, Object bean) {
        this.jmxBeans.put(fullyQualifiedMBeanName, bean);
    }

    public void removeBean(String fullyQualifiedMBeanName) {
        this.jmxBeans.remove(fullyQualifiedMBeanName);
    }

    public void initAfterBeansAdded() {
        this.exporter.setBeans(this.jmxBeans);
        this.exporter.afterPropertiesSet();
        this.exporter.afterSingletonsInstantiated();
    }
}

