/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang.javascript;

import com.google.common.base.Function;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.lang.LanguageSupport;
import com.predic8.membrane.core.lang.ScriptExecutorPool;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptLanguageSupport
extends LanguageSupport {
    private static final Logger log = LoggerFactory.getLogger(JavascriptLanguageSupport.class);

    @Override
    public Function<Map<String, Object>, Boolean> compileExpression(Router router, String src) {
        return new JavascriptScriptExecutorPool<Boolean>(router, this.getScriptWithImports(src)){

            public Boolean apply(Map<String, Object> parameters) {
                Object result = this.execute(parameters);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return false;
            }
        };
    }

    @Override
    public Function<Map<String, Object>, Object> compileScript(Router router, String script) {
        return new JavascriptScriptExecutorPool<Object>(router, this.getScriptWithImports(script)){

            public Object apply(Map<String, Object> parameters) {
                return this.execute(parameters);
            }
        };
    }

    private String getScriptWithImports(String src) {
        return "var imports = new JavaImporter(com.predic8.membrane.core.interceptor.Outcome,com.predic8.membrane.core.http)\nwith(imports){\n" + src + "\n}";
    }

    private abstract class JavascriptScriptExecutorPool<R>
    extends ScriptExecutorPool<ScriptEngine, R> {
        private final String javascriptCode;
        ScriptEngineManager sce;
        static final String javascriptEngineName = "nashorn";

        private JavascriptScriptExecutorPool(Router router, String expression) {
            this.javascriptCode = expression;
            this.sce = new ScriptEngineManager();
            this.init(router);
        }

        @Override
        protected Object invoke(ScriptEngine script, Map<String, Object> parameters) {
            for (String name : parameters.keySet()) {
                script.put(name, parameters.get(name));
            }
            try {
                return script.eval(this.javascriptCode);
            }
            catch (ScriptException e) {
                log.error("Error compiling script:", (Throwable)e);
                throw new RuntimeException("Error compiling script:", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ScriptEngine createOneScript() {
            ScriptEngineManager scriptEngineManager = this.sce;
            synchronized (scriptEngineManager) {
                return this.sce.getEngineByName(javascriptEngineName);
            }
        }
    }
}

