/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.RuleKey;
import com.predic8.membrane.core.stats.RuleStatisticCollector;
import com.predic8.membrane.core.transport.ssl.GeneratingSSLContext;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxy
implements Rule {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractProxy.class.getName());
    protected String name = "";
    protected RuleKey key;
    protected volatile boolean blockRequest;
    protected volatile boolean blockResponse;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected String localHost;
    private RuleStatisticCollector ruleStatisticCollector = new RuleStatisticCollector();
    private boolean active;
    private String error;
    protected Router router;
    private SSLContext sslInboundContext;
    private SSLParser sslInboundParser;

    public AbstractProxy() {
    }

    public AbstractProxy(RuleKey ruleKey) {
        this.key = ruleKey;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @MCChildElement(allowForeign=true, order=100)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RuleKey getKey() {
        return this.key;
    }

    @Override
    public boolean isBlockRequest() {
        return this.blockRequest;
    }

    @Override
    public boolean isBlockResponse() {
        return this.blockResponse;
    }

    @Override
    @MCAttribute
    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    @Override
    public void setKey(RuleKey ruleKey) {
        this.key = ruleKey;
    }

    @Override
    @MCAttribute
    public void setBlockRequest(boolean blockStatus) {
        this.blockRequest = blockStatus;
    }

    @Override
    @MCAttribute
    public void setBlockResponse(boolean blockStatus) {
        this.blockResponse = blockStatus;
    }

    protected abstract AbstractProxy getNewInstance();

    public SSLParser getSslInboundParser() {
        return this.sslInboundParser;
    }

    @MCChildElement(order=75)
    public void setSslInboundParser(SSLParser sslInboundParser) {
        this.sslInboundParser = sslInboundParser;
    }

    @Override
    public SSLContext getSslInboundContext() {
        return this.sslInboundContext;
    }

    protected void setSslInboundContext(SSLContext sslInboundContext) {
        this.sslInboundContext = sslInboundContext;
    }

    @Override
    public SSLProvider getSslOutboundContext() {
        return null;
    }

    @Override
    public final void init(Router router) throws Exception {
        this.router = router;
        try {
            this.init();
            for (Interceptor i : this.interceptors) {
                i.init(router);
            }
            this.active = true;
        }
        catch (Exception e) {
            if (!router.isRetryInit()) {
                throw e;
            }
            log.error("", (Throwable)e);
            this.active = false;
            this.error = e.getMessage();
        }
    }

    public void init() throws Exception {
        if (this.sslInboundParser != null) {
            if (this.sslInboundParser.getKeyGenerator() != null) {
                this.setSslInboundContext(new GeneratingSSLContext(this.sslInboundParser, this.router.getResolverMap(), this.router.getBaseLocation()));
            } else {
                this.setSslInboundContext(new StaticSSLContext(this.sslInboundParser, this.router.getResolverMap(), this.router.getBaseLocation()));
            }
        }
    }

    @Override
    public boolean isTargetAdjustHostHeader() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getErrorState() {
        return this.error;
    }

    @Override
    public AbstractProxy clone() throws CloneNotSupportedException {
        AbstractProxy clone = (AbstractProxy)super.clone();
        try {
            clone.init(this.router);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    @Override
    public RuleStatisticCollector getStatisticCollector() {
        return this.ruleStatisticCollector;
    }
}

