/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.administration.AdminConsoleInterceptor;
import com.predic8.membrane.core.rules.AbstractProxy;
import com.predic8.membrane.core.rules.AbstractServiceProxy;
import com.predic8.membrane.core.rules.ServiceProxyKey;

@MCElement(name="serviceProxy")
public class ServiceProxy
extends AbstractServiceProxy {
    private String externalHostname;

    @Override
    public void init() throws Exception {
        super.init();
        if (!(this.externalHostname == null || this.hasAdminConsole() && this.etcdRegistryApiConfigExists())) {
            throw new RuntimeException("externalHostname is only usable in combination with AdminConsoleInterceptor and EtcdRegistryApiConfig");
        }
    }

    public ServiceProxy() {
        this.key = new ServiceProxyKey(80);
    }

    public ServiceProxy(ServiceProxyKey ruleKey, String targetHost, int targetPort) {
        this.key = ruleKey;
        this.setTargetHost(targetHost);
        this.setTargetPort(targetPort);
    }

    public boolean hasAdminConsole() {
        for (Interceptor i : this.interceptors) {
            if (!(i instanceof AdminConsoleInterceptor)) continue;
            return true;
        }
        return false;
    }

    public boolean etcdRegistryApiConfigExists() {
        return false;
    }

    @Override
    protected AbstractProxy getNewInstance() {
        return new ServiceProxy();
    }

    public String getMethod() {
        return ((ServiceProxyKey)this.key).getMethod();
    }

    @MCAttribute
    public void setMethod(String method) {
        ((ServiceProxyKey)this.key).setMethod(method);
    }

    public String getExternalHostname() {
        return this.externalHostname;
    }

    @MCAttribute
    public void setExternalHostname(String externalHostname) {
        this.externalHostname = externalHostname;
    }

    public AbstractServiceProxy.Target getTarget() {
        return this.target;
    }

    @MCChildElement(order=150)
    public void setTarget(AbstractServiceProxy.Target target) {
        this.target = target;
    }

    public void setTargetHost(String targetHost) {
        this.target.setHost(targetHost);
    }

    public void setTargetPort(int targetPort) {
        this.target.setPort(targetPort);
    }

    public void setTargetURL(String targetURL) {
        this.target.setUrl(targetURL);
    }
}

