/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.rules;

import com.predic8.membrane.core.rules.AbstractRuleKey;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxyKey
extends AbstractRuleKey {
    private static Logger log = LoggerFactory.getLogger((String)ServiceProxyKey.class.getName());
    private String method = "*";
    private String host = "*";
    private boolean isHostWildCard = true;
    private Pattern hostPattern;

    public ServiceProxyKey(int port) {
        this(port, null);
    }

    public ServiceProxyKey(int port, String ip) {
        super(port, ip);
    }

    public ServiceProxyKey(String host, String method, String path, int port) {
        this(host, method, path, port, null);
    }

    public ServiceProxyKey(String host, String method, String path, int port, String ip) {
        super(port, ip);
        this.setHost(host);
        this.setPath(path);
        this.method = method;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public boolean isMethodWildcard() {
        return "*".equals(this.method.trim());
    }

    @Override
    public boolean isHostWildcard() {
        return this.isHostWildCard;
    }

    public String toString() {
        return (this.host.equals("*") ? "" : this.host + " ") + (this.method.equals("*") ? "" : this.method + " ") + StringUtils.defaultIfEmpty((String)this.getPath(), (String)"") + ":" + this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProxyKey other = (ServiceProxyKey)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.getPath() == null ? other.getPath() != null : !this.getPath().equals(other.getPath()));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host.trim();
        this.isHostWildCard = "*".equals(this.host);
        if (!this.isHostWildCard) {
            String pattern = ServiceProxyKey.createHostPattern(this.host);
            log.debug("Created host pattern match: " + pattern);
            this.hostPattern = Pattern.compile(pattern, 2);
        } else {
            this.hostPattern = null;
        }
    }

    public static String createHostPattern(String host) {
        StringBuilder regex = new StringBuilder();
        boolean quoted = false;
        boolean started = false;
        regex.append("(");
        block4: for (int i = 0; i < host.length(); ++i) {
            char c = host.charAt(i);
            switch (c) {
                case ' ': {
                    if (!started) continue block4;
                    if (quoted) {
                        regex.append("\\E");
                        quoted = false;
                    }
                    started = false;
                    regex.append(")|(");
                    continue block4;
                }
                case '*': {
                    if (quoted) {
                        regex.append("\\E");
                        quoted = false;
                    }
                    regex.append(".+");
                    started = true;
                    continue block4;
                }
                default: {
                    if (!quoted) {
                        regex.append("\\Q");
                        quoted = true;
                        started = true;
                    }
                    if (c == '\\') {
                        regex.append('\\');
                    }
                    regex.append(c);
                }
            }
        }
        if (quoted) {
            regex.append("\\E");
            quoted = false;
        }
        if (!started && regex.length() > 1) {
            regex.delete(regex.length() - 3, regex.length());
        }
        regex.append(")");
        String r = regex.toString();
        return r;
    }

    @Override
    public boolean matchesHostHeader(String hostHeader) {
        if (this.isHostWildCard) {
            return true;
        }
        if (hostHeader == null) {
            return false;
        }
        String requestHost = hostHeader.split(":")[0];
        log.debug("Rule host: " + this.host + ";  Request host: " + requestHost);
        return this.hostPattern.matcher(requestHost).matches();
    }

    public Pattern getHostPattern() {
        return this.hostPattern;
    }
}

