/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.google.common.base.Objects;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static Logger log = LoggerFactory.getLogger((String)ConnectionManager.class.getName());
    private final long keepAliveTimeout;
    private final long autoCloseInterval;
    private AtomicInteger numberInPool = new AtomicInteger();
    private HashMap<ConnectionKey, ArrayList<OldConnection>> availableConnections = new HashMap();
    private Timer timer;
    private volatile boolean shutdownWhenDone = false;

    public ConnectionManager(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
        this.autoCloseInterval = keepAliveTimeout * 2L;
        this.timer = new Timer("Connection Closer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (ConnectionManager.this.closeOldConnections() == 0 && ConnectionManager.this.shutdownWhenDone) {
                    ConnectionManager.this.timer.cancel();
                }
            }
        }, this.autoCloseInterval, this.autoCloseInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String host, int port, String localHost, SSLProvider sslProvider, int connectTimeout, @Nullable String sniServerName, @Nullable ProxyConfiguration proxy, @Nullable SSLContext proxySSLContext) throws UnknownHostException, IOException {
        log.debug("connection requested for " + host + ":" + port + (proxy != null ? " via " + proxy.getHost() + ":" + proxy.getPort() : ""));
        log.debug("Number of connections in pool: " + this.numberInPool.get());
        String cacheHost = host;
        int cachePort = port;
        if (proxy != null && sslProvider == null) {
            cacheHost = "";
            cachePort = 0;
        }
        ConnectionKey key = new ConnectionKey(cacheHost, cachePort, sslProvider, sniServerName, proxy);
        long now = System.currentTimeMillis();
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            ArrayList<OldConnection> l = this.availableConnections.get(key);
            if (l != null) {
                for (int i = l.size() - 1; i >= 0; --i) {
                    OldConnection c = l.get(i);
                    if (c.deathTime > now) {
                        l.remove(i);
                        return c.connection;
                    }
                    Collections.swap(l, 0, i);
                }
            }
        }
        Connection result = Connection.open(host, port, localHost, sslProvider, this, connectTimeout, sniServerName, proxy, proxySSLContext);
        this.numberInPool.incrementAndGet();
        return result;
    }

    public Connection getConnection(String host, int port, String localHost, SSLProvider sslProvider, int connectTimeout) throws UnknownHostException, IOException {
        return this.getConnection(host, port, localHost, sslProvider, connectTimeout, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        if (connection.isClosed()) {
            this.numberInPool.decrementAndGet();
            return;
        }
        ConnectionKey key = new ConnectionKey(connection.getHost(), connection.socket.getPort(), connection.getSslProvider(), connection.getSniServerName(), connection.getProxyConfiguration());
        OldConnection o = new OldConnection(connection, this.keepAliveTimeout);
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            ArrayList<OldConnection> l = this.availableConnections.get(key);
            if (l == null) {
                l = new ArrayList();
                this.availableConnections.put(key, l);
            }
            l.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int closeOldConnections() {
        int remaining;
        ArrayList<ConnectionKey> toRemove = new ArrayList<ConnectionKey>();
        ArrayList<Connection> toClose = new ArrayList<Connection>();
        long now = System.currentTimeMillis();
        log.trace("closing old connections");
        int closed = 0;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            for (Map.Entry<ConnectionKey, ArrayList<OldConnection>> e : this.availableConnections.entrySet()) {
                ArrayList<OldConnection> l = e.getValue();
                for (int i = 0; i < l.size(); ++i) {
                    OldConnection o = l.get(i);
                    if (o.deathTime >= now) continue;
                    if (i == l.size() - 1) {
                        l.remove(i);
                    } else {
                        l.set(i, l.remove(l.size() - 1));
                    }
                    --i;
                    ++closed;
                    toClose.add(o.connection);
                }
                if (!l.isEmpty()) continue;
                toRemove.add(e.getKey());
            }
            for (ConnectionKey remove : toRemove) {
                this.availableConnections.remove(remove);
            }
            remaining = this.availableConnections.size();
        }
        for (Connection c : toClose) {
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
        if (closed != 0) {
            log.debug("closed " + closed + " connections");
        }
        return remaining;
    }

    public void shutdownWhenDone() {
        this.shutdownWhenDone = true;
    }

    public int getNumberInPool() {
        return this.numberInPool.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number in pool: " + this.numberInPool.get() + "\n");
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            for (Map.Entry<ConnectionKey, ArrayList<OldConnection>> e : this.availableConnections.entrySet()) {
                sb.append("To " + e.getKey() + ": " + e.getValue().size() + "\n");
            }
        }
        return sb.toString();
    }

    private static class OldConnection {
        public final Connection connection;
        public final long deathTime;

        public OldConnection(Connection connection, long defaultKeepAliveTimeout) {
            long delta;
            this.connection = connection;
            long lastUse = connection.getLastUse();
            if (lastUse == 0L) {
                lastUse = System.currentTimeMillis();
            }
            if ((delta = connection.getTimeout()) == 0L) {
                delta = defaultKeepAliveTimeout;
            }
            delta = delta > 400L ? (delta -= 400L) : 0L;
            if (connection.getCompletedExchanges() >= connection.getMaxExchanges()) {
                delta = 0L;
            }
            this.deathTime = lastUse + delta;
        }
    }

    private static class ConnectionKey {
        public final String host;
        public final int port;
        @Nullable
        private SSLProvider sslProvider;
        @Nullable
        public String serverName;
        @Nullable
        public ProxyConfiguration proxy;

        public ConnectionKey(String host, int port, SSLProvider sslProvider, String serverName, ProxyConfiguration proxy) {
            this.host = host;
            this.port = port;
            this.sslProvider = sslProvider;
            this.serverName = serverName;
            this.proxy = proxy;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.host, this.port, this.sslProvider, this.serverName, this.proxy});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionKey) || obj == null) {
                return false;
            }
            ConnectionKey other = (ConnectionKey)obj;
            return this.host.equals(other.host) && this.port == other.port && Objects.equal((Object)this.sslProvider, (Object)other.sslProvider) && Objects.equal((Object)this.serverName, (Object)other.serverName) && Objects.equal((Object)this.proxy, (Object)other.proxy);
        }

        public String toString() {
            return this.host + ":" + this.port + (this.sslProvider != null ? " with SSL" : "") + (this.proxy != null ? " via proxy" : "");
        }
    }
}

