/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.ChunkedBodyTransferrer;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.PlainBodyTransferrer;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.model.AbstractExchangeViewerListener;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.ConnectionManager;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.HostColonPort;
import com.predic8.membrane.core.transport.http.HttpServerHandler;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.http.StreamPump;
import com.predic8.membrane.core.transport.http.WebSocketStreamPump;
import com.predic8.membrane.core.transport.http.client.AuthenticationConfiguration;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.transport.http.client.ProxyConfiguration;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static Logger log = LoggerFactory.getLogger((String)HttpClient.class.getName());
    @GuardedBy(value="HttpClient.class")
    private static SSLProvider defaultSSLProvider;
    private final ProxyConfiguration proxy;
    private final SSLContext proxySSLContext;
    private final AuthenticationConfiguration authentication;
    private final int timeBetweenTriesMs = 250;
    private final int maxRetries;
    private final int connectTimeout;
    private final String localAddr;
    private final SSLContext sslContext;
    private final ConnectionManager conMgr;
    private StreamPump.StreamPumpStats streamPumpStats;

    public HttpClient() {
        this(new HttpClientConfiguration());
    }

    public HttpClient(HttpClientConfiguration configuration) {
        this.proxy = configuration.getProxy();
        this.proxySSLContext = this.proxy != null && this.proxy.getSslParser() != null ? new StaticSSLContext(this.proxy.getSslParser(), new ResolverMap(), null) : null;
        if (configuration.getSslParser() != null) {
            if (configuration.getBaseLocation() == null) {
                throw new RuntimeException("Cannot find keystores as base location is unknown");
            }
            this.sslContext = new StaticSSLContext(configuration.getSslParser(), new ResolverMap(), configuration.getBaseLocation());
        } else {
            this.sslContext = null;
        }
        this.authentication = configuration.getAuthentication();
        this.maxRetries = configuration.getMaxRetries();
        this.connectTimeout = configuration.getConnection().getTimeout();
        this.localAddr = configuration.getConnection().getLocalAddr();
        this.conMgr = new ConnectionManager(configuration.getConnection().getKeepAliveTimeout());
    }

    public void setStreamPumpStats(StreamPump.StreamPumpStats streamPumpStats) {
        this.streamPumpStats = streamPumpStats;
    }

    protected void finalize() throws Throwable {
        this.conMgr.shutdownWhenDone();
    }

    private void setRequestURI(Request req, String dest) throws MalformedURLException {
        if (this.proxy != null || req.isCONNECTRequest()) {
            req.setUri(dest);
        } else {
            if (!dest.startsWith("http")) {
                throw new MalformedURLException("The exchange's destination URL (" + dest + ") does not start with 'http'. Please specify a <target> within your <serviceProxy>.");
            }
            String originalUri = req.getUri();
            req.setUri(HttpUtil.getPathAndQueryString(dest));
            if ("/".equals(originalUri) && req.getUri().isEmpty()) {
                req.setUri("/");
            }
        }
    }

    private HostColonPort getTargetHostAndPort(boolean connect, String dest) throws MalformedURLException, UnknownHostException {
        if (connect) {
            return new HostColonPort(false, dest);
        }
        return new HostColonPort(new URL(dest));
    }

    private HostColonPort init(Exchange exc, String dest, boolean adjustHostHeader) throws UnknownHostException, IOException, MalformedURLException {
        this.setRequestURI(exc.getRequest(), dest);
        HostColonPort target = this.getTargetHostAndPort(exc.getRequest().isCONNECTRequest(), dest);
        if (this.authentication != null) {
            exc.getRequest().getHeader().setAuthorization(this.authentication.getUsername(), this.authentication.getPassword());
        }
        if (adjustHostHeader && (exc.getRule() == null || exc.getRule().isTargetAdjustHostHeader())) {
            URL d = new URL(dest);
            exc.getRequest().getHeader().setHost(d.getHost() + ":" + HttpUtil.getPort(d));
        }
        return target;
    }

    private SSLProvider getOutboundSSLProvider(Exchange exc, HostColonPort hcp) {
        Object sslPropObj = exc.getProperty("SSL_CONTEXT");
        if (sslPropObj != null) {
            return (SSLProvider)sslPropObj;
        }
        if (hcp.useSSL) {
            if (this.sslContext != null) {
                return this.sslContext;
            }
            return HttpClient.getDefaultSSLProvider();
        }
        return null;
    }

    private static synchronized SSLProvider getDefaultSSLProvider() {
        if (defaultSSLProvider == null) {
            defaultSSLProvider = new StaticSSLContext(new SSLParser(), null, null);
        }
        return defaultSSLProvider;
    }

    public Exchange call(Exchange exc) throws Exception {
        return this.call(exc, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange call(Exchange exc, boolean adjustHostHeader, boolean failOverOn5XX) throws Exception {
        if (exc.getDestinations().isEmpty()) {
            throw new IllegalStateException("List of destinations is empty. Please specify at least one destination.");
        }
        Exception exception = null;
        Object trackNodeStatusObj = exc.getProperty("TRACK_NODE_STATUS");
        boolean trackNodeStatus = trackNodeStatusObj != null && trackNodeStatusObj instanceof Boolean && (Boolean)trackNodeStatusObj != false;
        this.disableStreamingForRetries(exc);
        for (int counter = 0; counter < this.maxRetries; ++counter) {
            Connection con = null;
            String dest = this.getDestination(exc, counter);
            HostColonPort target = null;
            try {
                boolean is5XX;
                Response response;
                log.debug("try # " + counter + " to " + dest);
                target = this.init(exc, dest, adjustHostHeader);
                if (counter == 0 && (con = exc.getTargetConnection()) != null) {
                    if (!con.isSame(target.host, target.port)) {
                        con.close();
                        con = null;
                    } else {
                        con.setKeepAttachedToExchange(true);
                    }
                }
                SSLProvider sslProvider = this.getOutboundSSLProvider(exc, target);
                if (con == null) {
                    con = this.conMgr.getConnection(target.host, target.port, this.localAddr, sslProvider, this.connectTimeout, this.getSNIServerName(exc), this.proxy, this.proxySSLContext);
                    con.setKeepAttachedToExchange(exc.getRequest().isBindTargetConnectionToIncoming());
                    exc.setTargetConnection(con);
                }
                if (this.proxy != null && sslProvider == null) {
                    exc.getRequest().getHeader().setProxyAutorization(this.proxy.getCredentials());
                }
                String newProtocol = null;
                if (exc.getRequest().isCONNECTRequest()) {
                    this.handleConnectRequest(exc, con);
                    response = Response.ok().build();
                    newProtocol = "CONNECT";
                } else {
                    response = this.doCall(exc, con);
                    if (trackNodeStatus) {
                        exc.setNodeStatusCode(counter, response.getStatusCode());
                    }
                    if (exc.getProperty("use-websocket") == Boolean.TRUE && this.isUpgradeToResponse(response, "websocket")) {
                        log.debug("Upgrading to WebSocket protocol.");
                        newProtocol = "WebSocket";
                    }
                    if (exc.getProperty("use-tcp") == Boolean.TRUE && this.isUpgradeToResponse(response, "tcp")) {
                        log.debug("Upgrading to TCP protocol.");
                        newProtocol = "TCP";
                    }
                    if (exc.getProperty("use-sdpy") == Boolean.TRUE && this.isUpgradeToResponse(response, "SPDY/3.1")) {
                        log.debug("Upgrading to SPDY/3.1 protocol.");
                        newProtocol = "SPDY/3.1";
                    }
                }
                if (newProtocol != null) {
                    this.setupConnectionForwarding(exc, con, newProtocol, this.streamPumpStats);
                    exc.getDestinations().clear();
                    exc.getDestinations().add(dest);
                    con.setExchange(exc);
                    exc.setResponse(response);
                    Exchange exchange = exc;
                    return exchange;
                }
                boolean bl = is5XX = 500 <= response.getStatusCode() && response.getStatusCode() < 600;
                if (failOverOn5XX && is5XX && counter != this.maxRetries - 1) continue;
                this.applyKeepAliveHeader(response, con);
                exc.getDestinations().clear();
                exc.getDestinations().add(dest);
                con.setExchange(exc);
                response.addObserver(con);
                exc.setResponse(response);
                Exchange exchange = exc;
                return exchange;
            }
            catch (ConnectException e) {
                exception = e;
                log.info("Connection to " + (target == null ? dest : target) + " refused.");
                continue;
            }
            catch (SocketException e) {
                if (e.getMessage().contains("Software caused connection abort")) {
                    log.info("Connection to " + dest + " was aborted externally. Maybe by the server or the OS Membrane is running on.");
                } else if (e.getMessage().contains("Connection reset")) {
                    log.info("Connection to " + dest + " was reset externally. Maybe by the server or the OS Membrane is running on.");
                } else {
                    this.logException(exc, counter, e);
                }
                exception = e;
                continue;
            }
            catch (UnknownHostException e) {
                log.warn("Unknown host: " + (target == null ? dest : target));
                exception = e;
                if (exc.getDestinations().size() >= 2) continue;
                break;
            }
            catch (EOFWhileReadingFirstLineException e) {
                log.debug("Server connection to " + dest + " terminated before line was read. Line so far: " + e.getLineSoFar());
                exception = e;
                continue;
            }
            catch (NoResponseException e) {
                throw e;
            }
            catch (Exception e) {
                this.logException(exc, counter, e);
                exception = e;
                continue;
            }
            finally {
                if (trackNodeStatus && exception != null) {
                    exc.setNodeException(counter, exception);
                }
            }
        }
        throw exception;
    }

    private void disableStreamingForRetries(Exchange exc) {
        if (this.maxRetries > 1) {
            exc.getRequest().addObserver(new MessageObserver(){

                @Override
                public void bodyRequested(AbstractBody body) {
                }

                @Override
                public void bodyComplete(AbstractBody body) {
                }
            });
        }
    }

    private String getSNIServerName(Exchange exc) {
        Object sniObject = exc.getProperty("SNI_SERVER_NAME");
        if (sniObject == null) {
            return null;
        }
        return (String)sniObject;
    }

    private void applyKeepAliveHeader(Response response, Connection con) {
        long max;
        String value = response.getHeader().getFirstValue("Keep-Alive");
        if (value == null) {
            return;
        }
        long timeoutSeconds = Header.parseKeepAliveHeader(value, "timeout");
        if (timeoutSeconds != -1L) {
            con.setTimeout(timeoutSeconds * 1000L);
        }
        if ((max = Header.parseKeepAliveHeader(value, "max")) != -1L && max < (long)con.getMaxExchanges()) {
            con.setMaxExchanges((int)max);
        }
    }

    private String getDestination(Exchange exc, int counter) {
        return exc.getDestinations().get(counter % exc.getDestinations().size());
    }

    private void logException(Exchange exc, int counter, Exception e) throws IOException {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("try # ");
            msg.append(counter);
            msg.append(" failed\n");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exc.getRequest().writeStartLine(baos);
            exc.getRequest().getHeader().write(baos);
            msg.append(Constants.ISO_8859_1_CHARSET.decode(ByteBuffer.wrap(baos.toByteArray())));
            if (e != null) {
                log.debug("{}", (Object)msg, (Object)e);
            } else {
                log.debug("{}", (Object)msg);
            }
        }
    }

    private Response doCall(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        exc.getRequest().write(con.out);
        exc.setTimeReqSent(System.currentTimeMillis());
        if (exc.getRequest().isHTTP10()) {
            this.shutDownRequestInputOutput(exc, con);
        }
        Response res = new Response();
        res.read(con.in, !exc.getRequest().isHEADRequest());
        if (res.getStatusCode() == 100) {
            this.do100ExpectedHandling(exc, res, con);
        }
        exc.setReceived();
        exc.setTimeResReceived(System.currentTimeMillis());
        return res;
    }

    public void setupConnectionForwarding(Exchange exc, final Connection con, final String protocol, StreamPump.StreamPumpStats streamPumpStats) throws SocketException {
        StreamPump b;
        StreamPump a;
        HttpServerHandler hsr = (HttpServerHandler)exc.getHandler();
        String source = hsr.getRemoteAddress();
        String dest = con.toString();
        if ("WebSocket".equals(protocol)) {
            WebSocketStreamPump aTemp = new WebSocketStreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getRule(), true, exc);
            WebSocketStreamPump bTemp = new WebSocketStreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getRule(), false, null);
            aTemp.init(bTemp);
            bTemp.init(aTemp);
            a = aTemp;
            b = bTemp;
        } else {
            a = new StreamPump(hsr.getSrcIn(), con.out, streamPumpStats, protocol + " " + source + " -> " + dest, exc.getRule());
            b = new StreamPump(con.in, hsr.getSrcOut(), streamPumpStats, protocol + " " + source + " <- " + dest, exc.getRule());
        }
        exc.addExchangeViewerListener(new AbstractExchangeViewerListener(){

            @Override
            public void setExchangeFinished() {
                String threadName = Thread.currentThread().getName();
                new Thread((Runnable)b, threadName + " " + protocol + " Backward Thread").start();
                try {
                    Thread.currentThread().setName(threadName + " " + protocol + " Onward Thread");
                    a.run();
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (IOException e) {
                        log.debug("", (Throwable)e);
                    }
                }
            }
        });
    }

    private boolean isUpgradeToResponse(Response res, String protocol) {
        return res.getStatusCode() == 101 && "upgrade".equalsIgnoreCase(res.getHeader().getFirstValue("Connection")) && protocol.equalsIgnoreCase(res.getHeader().getFirstValue("Upgrade"));
    }

    private void handleConnectRequest(Exchange exc, Connection con) throws IOException, EndOfStreamException {
        if (this.proxy != null) {
            exc.getRequest().write(con.out);
            Response response = new Response();
            response.read(con.in, false);
            log.debug("Status code response on CONNECT request: " + response.getStatusCode());
        }
        exc.getRequest().setUri("N/A");
    }

    private void do100ExpectedHandling(Exchange exc, Response response, Connection con) throws IOException, EndOfStreamException {
        exc.getRequest().getBody().write(exc.getRequest().getHeader().isChunked() ? new ChunkedBodyTransferrer(con.out) : new PlainBodyTransferrer(con.out));
        con.out.flush();
        response.read(con.in, !exc.getRequest().isHEADRequest());
    }

    private void shutDownRequestInputOutput(Exchange exc, Connection con) throws IOException {
        exc.getHandler().shutdownInput();
        Util.shutdownOutput(con.socket);
    }

    ConnectionManager getConnectionManager() {
        return this.conMgr;
    }
}

