/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URI {
    private java.net.URI uri;
    private String input;
    private String path;
    private String query;
    private String pathDecoded;
    private String queryDecoded;
    private static Pattern PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    private boolean customInit(String s) {
        Matcher m = PATTERN.matcher(s);
        if (!m.matches()) {
            return false;
        }
        this.input = s;
        this.path = m.group(5);
        this.query = m.group(7);
        return true;
    }

    URI(boolean allowCustomParsing, String s) throws URISyntaxException {
        try {
            this.uri = new java.net.URI(s);
        }
        catch (URISyntaxException e) {
            if (allowCustomParsing && this.customInit(s)) {
                return;
            }
            throw e;
        }
    }

    URI(String s, boolean useCustomParsing) throws URISyntaxException {
        if (useCustomParsing) {
            if (!this.customInit(s)) {
                throw new URISyntaxException(s, "URI did not match regular expression.");
            }
        } else {
            this.uri = new java.net.URI(s);
        }
    }

    public String getPath() {
        if (this.uri != null) {
            return this.uri.getPath();
        }
        if (this.pathDecoded == null) {
            this.pathDecoded = this.decode(this.path);
        }
        return this.pathDecoded;
    }

    public String getRawPath() {
        if (this.uri != null) {
            return this.uri.getRawPath();
        }
        return this.path;
    }

    public String getQuery() {
        if (this.uri != null) {
            return this.uri.getQuery();
        }
        if (this.queryDecoded == null) {
            this.queryDecoded = this.decode(this.query);
        }
        return this.queryDecoded;
    }

    private String decode(String string) {
        if (string == null) {
            return string;
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRawQuery() {
        if (this.uri != null) {
            return this.uri.getRawQuery();
        }
        return this.query;
    }

    public String toString() {
        if (this.uri != null) {
            return this.uri.toString();
        }
        return this.input;
    }
}

