/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cloud.etcd;

import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class EtcdRequest {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    HttpClient client = new HttpClient();
    SSLContext ssl = null;
    final String httpPrefix = "http://";
    final String bodySeperator = "&";
    String ip = "";
    String port = "";
    String root = "/v2/keys";
    String baseKey = "";
    String module = "";
    String uuid = "";
    String key = "";
    String value = "";
    String ttl = "";
    MethodType method = MethodType.GET;
    String url = "";
    String body = "";
    String isDir = "";
    String prevExist = "";
    String longPoll = "";
    String recursiveLongPoll = "";
    String waitIndex = "";

    public HttpClient getClient() {
        return this.client;
    }

    public EtcdRequest client(HttpClient client) {
        this.client = client;
        return this;
    }

    public static EtcdRequest create(String url, String baseKey, String module) {
        return new EtcdRequest().url(url).baseKey(baseKey).module(module);
    }

    public static EtcdRequest create(SSLContext ssl, String url, String baseKey, String module) {
        EtcdRequest req = EtcdRequest.create(url, baseKey, module);
        return req.ssl(ssl);
    }

    private EtcdRequest ssl(SSLContext ssl) {
        this.ssl = ssl;
        return this;
    }

    public EtcdRequest defaultModule() {
        this.module("/eep");
        return this;
    }

    public EtcdRequest defaultBaseKey() {
        this.baseKey("/asa/lb");
        return this;
    }

    public EtcdRequest local() {
        this.ip("localhost").port("4001");
        return this;
    }

    public EtcdRequest url(String url) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            try {
                u = new URL("http://" + url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (u != null) {
            this.ip(u.getHost()).port(Integer.toString(u.getPort()));
        }
        return this;
    }

    public EtcdRequest module(String module) {
        this.module = module;
        return this;
    }

    public EtcdRequest baseKey(String baseModule) {
        this.baseKey = baseModule;
        return this;
    }

    public EtcdRequest port(String port) {
        this.port = ":" + port;
        return this;
    }

    public EtcdRequest ip(String ip) {
        this.ip = ip;
        return this;
    }

    public EtcdRequest uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public EtcdRequest setValue(String key, String value) {
        this.key = "/" + key;
        this.value = "value=" + value;
        this.method = MethodType.PUT;
        return this;
    }

    public EtcdRequest getValue(String key) {
        this.key = "/" + key;
        this.value = "";
        this.method = MethodType.GET;
        return this;
    }

    public EtcdRequest createDir(String dir) {
        this.isDir = "dir=true";
        this.key = dir;
        this.value = "";
        this.method = MethodType.PUT;
        return this;
    }

    public EtcdRequest deleteValue(String key) {
        this.key = key;
        this.value = "";
        this.method = MethodType.DELETE;
        return this;
    }

    public EtcdRequest deleteDir() {
        this.isDir = "dir=true";
        this.value = "";
        this.method = MethodType.DELETE;
        return this;
    }

    public EtcdRequest ttl(int seconds) {
        this.ttl = "ttl=" + seconds;
        return this;
    }

    public static EtcdRequest refreshTTLSta(int seconds) {
        EtcdRequest req = new EtcdRequest();
        req.method = MethodType.PUT;
        req.prevExist = "prevExist=true";
        return req.ttl(seconds);
    }

    public EtcdRequest refreshTTL(int seconds) {
        this.method = MethodType.PUT;
        this.prevExist = "prevExist=true";
        return this.ttl(seconds);
    }

    public EtcdRequest longPoll() {
        this.method = MethodType.GET;
        this.longPoll = "wait=true";
        return this;
    }

    public EtcdRequest longPollRecursive() {
        this.recursiveLongPoll = "recursive=true";
        return this.longPoll();
    }

    public EtcdRequest longPollRecursive(long index) {
        this.waitIndex = "waitIndex=" + index;
        return this.longPollRecursive();
    }

    public EtcdResponse sendRequest() {
        Exchange requestExc = null;
        try {
            requestExc = this.getExchange();
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException();
        }
        if (requestExc == null) {
            throw new RuntimeException();
        }
        if (this.ssl != null) {
            requestExc.setProperty("SSL_CONTEXT", this.ssl);
        }
        try {
            return new EtcdResponse(this, this.client.call(requestExc).getResponse());
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Exchange getExchange() throws URISyntaxException {
        switch (this.method) {
            case GET: {
                this.createGetRequest();
                return new Request.Builder().get(this.url).buildExchange();
            }
            case DELETE: {
                this.createDeleteRequest();
                return new Request.Builder().delete(this.url).buildExchange();
            }
            case POST: {
                this.createPostRequest();
                return new Request.Builder().contentType(APPLICATION_X_WWW_FORM_URLENCODED).post(this.url).buildExchange();
            }
            case PUT: {
                this.createPutRequest();
                return new Request.Builder().contentType(APPLICATION_X_WWW_FORM_URLENCODED).put(this.url).body(this.body).buildExchange();
            }
        }
        throw new RuntimeException("Method not supported");
    }

    protected EtcdRequest createPutRequest() {
        StringBuilder builder = new StringBuilder();
        builder.append("http://").append(this.ip).append(this.port).append(this.root).append(this.baseKey).append(this.module).append(this.uuid).append(this.key);
        this.url = builder.toString();
        builder.setLength(0);
        this.addWithLineSeperator(builder, this.value, this.ttl, this.isDir, this.prevExist);
        this.body = builder.toString();
        return this;
    }

    private void addWithLineSeperator(StringBuilder builder, String ... values) {
        if (values.length == 0) {
            return;
        }
        boolean putSeperator = false;
        for (String val : values) {
            if (putSeperator) {
                if (val.equals("")) continue;
                builder.append("&");
                putSeperator = false;
            }
            if (val.equals("")) continue;
            builder.append(val);
            putSeperator = true;
        }
    }

    private void addQueries(StringBuilder builder, String ... queries) {
        if (queries.length == 0) {
            return;
        }
        if (!queries[0].equals("")) {
            builder.append("?" + queries[0]);
        }
        for (int i = 1; i < queries.length; ++i) {
            if (queries[i].equals("")) continue;
            builder.append("&" + queries[i]);
        }
    }

    protected EtcdRequest createPostRequest() {
        return this;
    }

    protected EtcdRequest createDeleteRequest() {
        StringBuilder builder = new StringBuilder();
        builder.append("http://").append(this.ip).append(this.port).append(this.root).append(this.baseKey).append(this.module).append(this.uuid);
        this.url = builder.toString();
        this.body = "";
        return this;
    }

    protected EtcdRequest createGetRequest() {
        StringBuilder builder = new StringBuilder();
        builder.append("http://").append(this.ip).append(this.port).append(this.root).append(this.baseKey).append(this.module).append(this.uuid).append(this.key);
        this.addQueries(builder, this.longPoll, this.recursiveLongPoll, this.waitIndex);
        this.url = builder.toString();
        this.body = "";
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    static enum MethodType {
        GET,
        PUT,
        DELETE,
        POST;

    }
}

