/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MEMBRANE_BEANS_NAMESPACE = "http://membrane-soa.org/proxies/1/";
    private static final String MEMBRANE_PROXIES_NAMESPACE = "http://membrane-soa.org/proxies/1/";
    private boolean inlined = false;

    public BeanDefinition parse(Element e) {
        this.inlined = true;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)this.getBeanClass(e));
        this.doParse(e, builder);
        return builder.getBeanDefinition();
    }

    protected void setIdIfNeeded(Element element, ParserContext parserContext, String defaultId) {
        if (!this.isInlined() && !element.hasAttribute("id")) {
            HashSet names = Sets.newHashSet((Object[])parserContext.getRegistry().getBeanDefinitionNames());
            int i = 0;
            while (true) {
                String id;
                if (!names.contains(id = defaultId + (i == 0 ? "" : Integer.valueOf(i)))) {
                    element.setAttribute("id", id);
                    return;
                }
                ++i;
            }
        }
    }

    protected boolean isInlined() {
        return this.inlined;
    }

    protected void setProperty(String prop, Element e, BeanDefinitionBuilder builder) {
        this.setProperty(prop, prop, e, builder);
    }

    protected void setProperty(String prop, Element e, BeanDefinitionBuilder builder, boolean flexibleEnum) {
        this.setProperty(prop, prop, e, builder, flexibleEnum);
    }

    protected void setProperty(String xmlPropertyName, String springPropertyName, Element e, BeanDefinitionBuilder builder) {
        this.setProperty(xmlPropertyName, springPropertyName, e, builder, false);
    }

    protected void setProperty(String xmlPropertyName, String springPropertyName, Element e, BeanDefinitionBuilder builder, boolean flexibleEnum) {
        String value = e.getAttribute(xmlPropertyName);
        if (flexibleEnum) {
            value = value.toUpperCase();
        }
        builder.addPropertyValue(springPropertyName, (Object)value);
    }

    protected void setPropertyIfSet(String prop, Element e, BeanDefinitionBuilder builder) {
        this.setPropertyIfSet(prop, prop, e, builder);
    }

    protected void setPropertyIfSet(String prop, Element e, BeanDefinitionBuilder builder, boolean flexibleEnum) {
        this.setPropertyIfSet(prop, prop, e, builder, flexibleEnum);
    }

    protected void setPropertyIfSet(String xmlPropertyName, String springPropertyName, Element e, BeanDefinitionBuilder builder) {
        this.setPropertyIfSet(xmlPropertyName, springPropertyName, e, builder, false);
    }

    protected void setPropertyIfSet(String xmlPropertyName, String springPropertyName, Element e, BeanDefinitionBuilder builder, boolean flexibleEnum) {
        if (e.hasAttribute(xmlPropertyName)) {
            this.setProperty(xmlPropertyName, springPropertyName, e, builder, flexibleEnum);
        }
    }

    protected void setProperties(String prop, Element e, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = e.getAttributes();
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr item = (Attr)attributes.item(i);
            if (item.getLocalName() == null) continue;
            attrs.put(item.getLocalName(), item.getValue());
        }
        builder.addPropertyValue(prop, attrs);
    }

    protected void parseElementToProperty(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, String property) {
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        if (delegate.isDefaultNamespace((Node)ele)) {
            Object o = delegate.parsePropertySubElement(ele, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue(property, o);
        } else {
            BeanDefinition bd = delegate.parseCustomElement(ele);
            builder.addPropertyValue(property, (Object)bd);
        }
    }

    protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
        throw new RuntimeException("Do not know how to handle child of class " + clazz + ". Please override handleChildObject().");
    }

    protected void parseChildren(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            this.handleChildElement((Element)node, parserContext, builder);
        }
    }

    protected void handleChildElement(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        try {
            Object o = delegate.parsePropertySubElement(ele, (BeanDefinition)builder.getBeanDefinition());
            String clazz = null;
            if (o instanceof BeanDefinitionHolder) {
                clazz = ((BeanDefinitionHolder)o).getBeanDefinition().getBeanClassName();
            } else if (o instanceof RuntimeBeanReference) {
                clazz = parserContext.getRegistry().getBeanDefinition(((RuntimeBeanReference)o).getBeanName()).getBeanClassName();
            } else if (o instanceof RuntimeBeanNameReference) {
                clazz = parserContext.getRegistry().getBeanDefinition(((RuntimeBeanNameReference)o).getBeanName()).getBeanClassName();
            } else {
                parserContext.getReaderContext().error("Don't know how to get bean class from " + o.getClass(), (Object)ele);
            }
            this.handleChildObject(ele, parserContext, builder, Class.forName(clazz), o);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected int incrementCounter(BeanDefinitionBuilder builder, String counter) {
        Integer i = (Integer)builder.getRawBeanDefinition().getAttribute(counter);
        if (i == null) {
            i = 0;
        }
        builder.getRawBeanDefinition().setAttribute(counter, (Object)(i + 1));
        return i;
    }

    protected boolean isMembraneNamespace(String namespace) {
        return "http://membrane-soa.org/proxies/1/".equals(namespace) || "http://membrane-soa.org/proxies/1/".equals(namespace);
    }

    protected void setProperty(BeanDefinitionBuilder builder, String propertyName, Object value) {
        if (value instanceof RuntimeBeanNameReference) {
            builder.addPropertyReference(propertyName, ((RuntimeBeanNameReference)value).getBeanName());
        } else {
            builder.addPropertyValue(propertyName, value);
        }
    }
}

