/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.spring.AbstractParser;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.URIFactory;
import java.util.ArrayList;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RouterParser
extends AbstractParser {
    protected Class<?> getBeanClass(Element element) {
        return Router.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setIdIfNeeded(element, parserContext, "router");
        if (element.hasAttribute("exchangeStore")) {
            builder.addPropertyReference("exchangeStore", element.getAttribute("exchangeStore"));
        }
        this.setPropertyIfSet("retryInitInterval", "retryInitInterval", element, builder);
        this.setPropertyIfSet("retryInit", "retryInit", element, builder);
        this.setPropertyIfSet("jmx", "jmx", element, builder);
        builder.addPropertyValue("rules", new ArrayList());
        this.parseChildren(element, parserContext, builder);
    }

    @Override
    protected void handleChildObject(Element ele, ParserContext parserContext, BeanDefinitionBuilder builder, Class<?> clazz, Object child) {
        if (URIFactory.class.isAssignableFrom(clazz)) {
            this.setProperty(builder, "uriFactory", child);
        } else if (HttpClientConfiguration.class.isAssignableFrom(clazz)) {
            this.setProperty(builder, "httpClientConfig", child);
        } else if (Transport.class.isAssignableFrom(clazz)) {
            this.setProperty(builder, "transport", child);
        } else if (Rule.class.isAssignableFrom(clazz)) {
            this.setProperty(builder, "rules[" + this.incrementCounter(builder, "rules") + "]", child);
        } else {
            throw new RuntimeException("Unknown child class \"" + clazz + "\".");
        }
    }
}

