/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.spring.blueprint;

import com.predic8.membrane.annot.parser.BlueprintElementParser;
import com.predic8.membrane.annot.parser.BlueprintParser;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.URIFactory;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;

public class RouterParser
extends BlueprintElementParser {
    public Metadata parse(BlueprintParser globalParser, Element element, ParserContext context) {
        MutableBeanMetadata mcm = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        mcm.setId(context.generateId());
        mcm.setScope("singleton");
        mcm.setRuntimeClass(Router.class);
        this.applySpringInterfacePatches(context, Router.class, mcm);
        this.setIdIfNeeded(element, context, "router");
        if (element.hasAttribute("exchangeStore")) {
            this.setPropertyReference(context, "exchangeStore", element.getAttribute("exchangeStore"), mcm);
        }
        this.setPropertyIfSet(context, "retryInitInterval", "retryInitInterval", element, mcm);
        this.setPropertyIfSet(context, "retryInit", "retryInit", element, mcm);
        this.setPropertyIfSet(context, "jmx", "jmx", element, mcm);
        this.parseChildren(element, context, mcm, globalParser);
        return mcm;
    }

    protected void handleChildObject(Element ele, ParserContext context, MutableBeanMetadata mcm, Class<?> clazz, Object child) {
        if (URIFactory.class.isAssignableFrom(clazz)) {
            this.setProperty(context, mcm, "uriFactory", child);
        } else if (HttpClientConfiguration.class.isAssignableFrom(clazz)) {
            this.setProperty(context, mcm, "httpClientConfig", child);
        } else if (Transport.class.isAssignableFrom(clazz)) {
            this.setProperty(context, mcm, "transport", child);
        } else if (Rule.class.isAssignableFrom(clazz)) {
            this.appendToListProperty(context, mcm, "rules", child);
        } else {
            throw new RuntimeException("Unknown child class \"" + clazz + "\".");
        }
    }
}

