/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange;

import com.predic8.membrane.core.TerminateException;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exchange
extends AbstractExchange {
    public static final String HTTP_SERVLET_REQUEST = "HttpServletRequest";
    public static final String ALLOW_WEBSOCKET = "use-websocket";
    public static final String ALLOW_TCP = "use-tcp";
    public static final String ALLOW_SPDY = "use-sdpy";
    public static final String TRACK_NODE_STATUS = "TRACK_NODE_STATUS";
    public static final String SSL_CONTEXT = "SSL_CONTEXT";
    public static final String API_KEY = "API_KEY";
    public static final String OAUTH2 = "oauth2";
    public static final String SNI_SERVER_NAME = "SNI_SERVER_NAME";
    public static final String WS_ORIGINAL_EXCHANGE = "WS_ORIGINAL_EXCHANGE";
    private static Logger log = LoggerFactory.getLogger((String)Exchange.class.getName());
    private AbstractHttpHandler handler;
    private String originalHostHeader = "";
    private Connection targetConnection;
    private int[] nodeStatusCodes;
    private Exception[] nodeExceptions;
    private long id;

    public Exchange(AbstractHttpHandler handler) {
        this.handler = handler;
        this.id = this.hashCode();
    }

    public Exchange(Exchange original, AbstractHttpHandler handler) {
        super(original);
        this.handler = handler;
        this.originalHostHeader = original.originalHostHeader;
        this.id = this.hashCode();
    }

    public AbstractHttpHandler getHandler() {
        return this.handler;
    }

    public String getOriginalHostHeaderHost() {
        return this.originalHostHeader.replaceFirst(":.*", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockRequestIfNeeded() throws TerminateException {
        if (this.getRule().isBlockRequest()) {
            Request request = this.getRequest();
            synchronized (request) {
                this.setStopped();
                this.block(this.getRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockResponseIfNeeded() throws TerminateException {
        if (this.getRule().isBlockResponse()) {
            Response response = this.getResponse();
            synchronized (response) {
                this.setStopped();
                this.block(this.getResponse());
            }
        }
    }

    public void block(Message msg) throws TerminateException {
        try {
            log.debug("Message thread waits");
            msg.wait();
            log.debug("Message thread received notify");
            if (this.isForcedToStop()) {
                throw new TerminateException("Force the exchange to stop.");
            }
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public String getOriginalHostHeaderPort() {
        return this.originalHostHeader.replaceFirst(".*:", "");
    }

    public String getOriginalHostHeader() {
        return this.originalHostHeader;
    }

    public void setOriginalHostHeader(String hostHeader) {
        this.originalHostHeader = hostHeader;
    }

    @Override
    public void setRequest(Request req) {
        super.setRequest(req);
        this.setOriginalHostHeader(req.getHeader().getHost());
    }

    public Connection getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(Connection con) {
        this.targetConnection = con;
    }

    public void collectStatistics() {
        this.rule.getStatisticCollector().collect(this);
    }

    public String getRequestURI() {
        if (HttpUtil.isAbsoluteURI(this.getOriginalRequestUri())) {
            try {
                return new URL(this.getOriginalRequestUri()).getFile();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Request has a malformed URI: " + this.getOriginalRequestUri(), e);
            }
        }
        return this.getOriginalRequestUri();
    }

    public Outcome echo() throws IOException {
        String contentEncoding;
        Response.ResponseBuilder builder = Response.ok();
        byte[] content = this.getRequest().getBody().getContent();
        builder.body(content);
        String contentType = this.getRequest().getHeader().getContentType();
        if (contentType != null) {
            builder.header("Content-Type", contentType);
        }
        if ((contentEncoding = this.getRequest().getHeader().getContentEncoding()) != null) {
            builder.header("Content-Encoding", contentEncoding);
        }
        this.setResponse(builder.build());
        return Outcome.RETURN;
    }

    public Map<String, String> getStringProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry e : this.properties.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            map.put((String)e.getKey(), (String)e.getValue());
        }
        return map;
    }

    public void setNodeStatusCode(int tryCounter, int code) {
        if (this.nodeStatusCodes == null) {
            this.nodeStatusCodes = new int[this.getDestinations().size()];
        }
        this.nodeStatusCodes[tryCounter % this.getDestinations().size()] = code;
    }

    public void setNodeException(int tryCounter, Exception e) {
        if (this.nodeExceptions == null) {
            this.nodeExceptions = new Exception[this.getDestinations().size()];
        }
        this.nodeExceptions[tryCounter % this.getDestinations().size()] = e;
    }

    @Override
    public void detach() {
        super.detach();
        this.handler = null;
    }

    public boolean canKeepConnectionAlive() {
        return this.getRequest().isKeepAlive() && this.getResponse().isKeepAlive();
    }

    @Override
    public long getId() {
        return this.id;
    }

    public AbstractExchange createSnapshot() throws Exception {
        Exchange exc = Exchange.updateCopy(this, new Exchange(null));
        exc.setId(this.getId());
        return exc;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int[] getNodeStatusCodes() {
        return this.nodeStatusCodes;
    }

    public void setNodeStatusCodes(int[] nodeStatusCodes) {
        this.nodeStatusCodes = nodeStatusCodes;
    }

    public Exception[] getNodeExceptions() {
        return this.nodeExceptions;
    }

    public void setNodeExceptions(Exception[] nodeExceptions) {
        this.nodeExceptions = nodeExceptions;
    }
}

