/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.exchange.snapshots;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.exchange.snapshots.FakeRule;
import com.predic8.membrane.core.exchange.snapshots.RequestSnapshot;
import com.predic8.membrane.core.exchange.snapshots.ResponseSnapshot;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AbstractExchangeSnapshot {
    RequestSnapshot request;
    ResponseSnapshot response;
    String originalRequestUri;
    Calendar time;
    String errorMessage;
    ExchangeState status;
    long timeReqSent;
    long timeReqReceived;
    long timeResSent;
    long timeResReceived;
    List<String> destinations;
    String remoteAddr;
    String remoteAddrIp;
    FakeRule rule;
    String server;
    long id;

    public AbstractExchangeSnapshot(AbstractExchange exc) {
        this.updateFrom(exc);
    }

    public AbstractExchangeSnapshot() {
    }

    public <T extends AbstractExchangeSnapshot> T updateFrom(AbstractExchange source) {
        if (source.getRequest() != null) {
            this.setRequest(new RequestSnapshot(source.getRequest()));
        }
        if (source.getResponse() != null) {
            this.setResponse(new ResponseSnapshot(source.getResponse()));
        }
        this.setOriginalRequestUri(source.getOriginalRequestUri());
        this.setTime(source.getTime());
        this.setErrorMessage(source.getErrorMessage());
        this.setStatus(source.getStatus());
        this.setTimeReqSent(source.getTimeReqSent());
        this.setTimeReqReceived(source.getTimeReqReceived());
        this.setTimeResSent(source.getTimeResSent());
        this.setTimeResReceived(source.getTimeResReceived());
        this.setDestinations(source.getDestinations().stream().collect(Collectors.toList()));
        this.setRemoteAddr(source.getRemoteAddr());
        this.setRemoteAddrIp(source.getRemoteAddrIp());
        this.setId(source.getId());
        this.setRule(new FakeRule(source.getRule()));
        this.setServer(source.getServer());
        return (T)this;
    }

    public AbstractExchange toAbstractExchange() {
        Exchange exc = new Exchange(null);
        if (this.getRequest() != null) {
            exc.setRequest(this.getRequest().toRequest());
        }
        if (this.getResponse() != null) {
            exc.setResponse(this.getResponse().toResponse());
        }
        exc.setOriginalRequestUri(this.getOriginalRequestUri());
        exc.setTime(this.getTime());
        exc.setErrorMessage(this.getErrorMessage());
        exc.setStatus(this.getStatus());
        exc.setTimeReqSent(this.getTimeReqSent());
        exc.setTimeReqReceived(this.getTimeReqReceived());
        exc.setTimeResSent(this.getTimeResSent());
        exc.setTimeResReceived(this.getTimeResReceived());
        exc.setDestinations(this.getDestinations().stream().collect(Collectors.toList()));
        exc.setRemoteAddr(this.getRemoteAddr());
        exc.setRemoteAddrIp(this.getRemoteAddrIp());
        exc.setId(this.getId());
        exc.setRule(this.getRule());
        this.setServer(this.getServer());
        return exc;
    }

    public RequestSnapshot getRequest() {
        return this.request;
    }

    public void setRequest(RequestSnapshot request) {
        this.request = request;
    }

    public ResponseSnapshot getResponse() {
        return this.response;
    }

    public void setResponse(ResponseSnapshot response) {
        this.response = response;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getOriginalRequestUri() {
        return this.originalRequestUri;
    }

    public void setOriginalRequestUri(String originalRequestUri) {
        this.originalRequestUri = originalRequestUri;
    }

    public Calendar getTime() {
        return this.time;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ExchangeState getStatus() {
        return this.status;
    }

    public void setStatus(ExchangeState status) {
        this.status = status;
    }

    public long getTimeReqSent() {
        return this.timeReqSent;
    }

    public void setTimeReqSent(long timeReqSent) {
        this.timeReqSent = timeReqSent;
    }

    public long getTimeReqReceived() {
        return this.timeReqReceived;
    }

    public void setTimeReqReceived(long timeReqReceived) {
        this.timeReqReceived = timeReqReceived;
    }

    public long getTimeResSent() {
        return this.timeResSent;
    }

    public void setTimeResSent(long timeResSent) {
        this.timeResSent = timeResSent;
    }

    public long getTimeResReceived() {
        return this.timeResReceived;
    }

    public void setTimeResReceived(long timeResReceived) {
        this.timeResReceived = timeResReceived;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddrIp() {
        return this.remoteAddrIp;
    }

    public void setRemoteAddrIp(String remoteAddrIp) {
        this.remoteAddrIp = remoteAddrIp;
    }

    public FakeRule getRule() {
        return this.rule;
    }

    public void setRule(FakeRule rule) {
        this.rule = rule;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

