/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.cookie;

import com.predic8.membrane.core.http.cookie.ByteChunk;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StringCache {
    protected static boolean byteEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.byte.enabled", "false"));
    protected static boolean charEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.char.enabled", "false"));
    protected static int trainThreshold = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.trainThreshold", "20000"));
    protected static int cacheSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.cacheSize", "200"));
    protected static int maxStringSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.maxStringSize", "128"));
    protected static HashMap<ByteEntry, int[]> bcStats = new HashMap(cacheSize);
    protected static int bcCount = 0;
    protected static ByteEntry[] bcCache = null;
    protected static HashMap<CharEntry, int[]> ccStats = new HashMap(cacheSize);
    protected static int ccCount = 0;
    protected static CharEntry[] ccCache = null;
    protected static int accessCount = 0;
    protected static int hitCount = 0;

    public int getCacheSize() {
        return cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        StringCache.cacheSize = cacheSize;
    }

    public boolean getByteEnabled() {
        return byteEnabled;
    }

    public void setByteEnabled(boolean byteEnabled) {
        StringCache.byteEnabled = byteEnabled;
    }

    public boolean getCharEnabled() {
        return charEnabled;
    }

    public void setCharEnabled(boolean charEnabled) {
        StringCache.charEnabled = charEnabled;
    }

    public int getTrainThreshold() {
        return trainThreshold;
    }

    public void setTrainThreshold(int trainThreshold) {
        StringCache.trainThreshold = trainThreshold;
    }

    public int getAccessCount() {
        return accessCount;
    }

    public int getHitCount() {
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        hitCount = 0;
        accessCount = 0;
        HashMap<Object, int[]> hashMap = bcStats;
        synchronized (hashMap) {
            bcCache = null;
            bcCount = 0;
        }
        hashMap = ccStats;
        synchronized (hashMap) {
            ccCache = null;
            ccCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteChunk bc) {
        if (bcCache == null) {
            String value = bc.toStringInternal();
            if (byteEnabled && value.length() < maxStringSize) {
                HashMap<ByteEntry, int[]> hashMap = bcStats;
                synchronized (hashMap) {
                    if (bcCache != null) {
                        return value;
                    }
                    if (bcCount > trainThreshold) {
                        ArrayList<ByteEntry> list;
                        TreeMap<Integer, ArrayList<ByteEntry>> tempMap = new TreeMap<Integer, ArrayList<ByteEntry>>();
                        for (Map.Entry<ByteEntry, int[]> item : bcStats.entrySet()) {
                            ByteEntry entry = item.getKey();
                            int[] countA = item.getValue();
                            Integer count = countA[0];
                            list = (ArrayList<ByteEntry>)tempMap.get(count);
                            if (list == null) {
                                list = new ArrayList<ByteEntry>();
                                tempMap.put(count, list);
                            }
                            list.add(entry);
                        }
                        int size = bcStats.size();
                        if (size > cacheSize) {
                            size = cacheSize;
                        }
                        ByteEntry[] tempbcCache = new ByteEntry[size];
                        ByteChunk tempChunk = new ByteChunk();
                        int n = 0;
                        while (n < size) {
                            Object key = tempMap.lastKey();
                            list = (ArrayList)tempMap.get(key);
                            for (int i = 0; i < list.size() && n < size; ++n, ++i) {
                                ByteEntry entry = (ByteEntry)list.get(i);
                                tempChunk.setBytes(entry.name, 0, entry.name.length);
                                int insertPos = StringCache.findClosest(tempChunk, tempbcCache, n);
                                if (insertPos == n) {
                                    tempbcCache[n + 1] = entry;
                                    continue;
                                }
                                System.arraycopy(tempbcCache, insertPos + 1, tempbcCache, insertPos + 2, n - insertPos - 1);
                                tempbcCache[insertPos + 1] = entry;
                            }
                            tempMap.remove(key);
                        }
                        bcCount = 0;
                        bcStats.clear();
                        bcCache = tempbcCache;
                    } else {
                        ++bcCount;
                        ByteEntry entry = new ByteEntry();
                        entry.value = value;
                        int[] count = bcStats.get(entry);
                        if (count == null) {
                            int end = bc.getEnd();
                            int start = bc.getStart();
                            entry.name = new byte[bc.getLength()];
                            System.arraycopy(bc.getBuffer(), start, entry.name, 0, end - start);
                            entry.charset = bc.getCharset();
                            count = new int[]{1};
                            bcStats.put(entry, count);
                        } else {
                            count[0] = count[0] + 1;
                        }
                    }
                }
            }
            return value;
        }
        ++accessCount;
        String result = StringCache.find(bc);
        if (result == null) {
            return bc.toStringInternal();
        }
        ++hitCount;
        return result;
    }

    protected static final int compare(ByteChunk name, byte[] compareTo) {
        int len;
        int result = 0;
        byte[] b = name.getBuffer();
        int start = name.getStart();
        int end = name.getEnd();
        if (end - start < (len = compareTo.length)) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (b[i + start] > compareTo[i]) {
                result = 1;
                continue;
            }
            if (b[i + start] >= compareTo[i]) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length > end - start) {
                result = -1;
            } else if (compareTo.length < end - start) {
                result = 1;
            }
        }
        return result;
    }

    protected static final String find(ByteChunk name) {
        int pos = StringCache.findClosest(name, bcCache, bcCache.length);
        if (pos < 0 || StringCache.compare(name, StringCache.bcCache[pos].name) != 0 || !name.getCharset().equals(StringCache.bcCache[pos].charset)) {
            return null;
        }
        return StringCache.bcCache[pos].value;
    }

    protected static final int findClosest(ByteChunk name, ByteEntry[] array, int len) {
        int a = 0;
        int b = len - 1;
        if (b == -1) {
            return -1;
        }
        if (StringCache.compare(name, array[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        int i = 0;
        do {
            i = b + a >>> 1;
            int result = StringCache.compare(name, array[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = StringCache.compare(name, array[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    public static class CharEntry {
        public char[] name = null;
        public String value = null;

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CharEntry) {
                return this.value.equals(((CharEntry)obj).value);
            }
            return false;
        }
    }

    public static class ByteEntry {
        public byte[] name = null;
        public Charset charset = null;
        public String value = null;

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ByteEntry) {
                return this.value.equals(((ByteEntry)obj).value);
            }
            return false;
        }
    }
}

