/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.http.xml;

import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.http.Message;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class XMLBody
extends AbstractXmlElement {
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final Message msg;
    private final String charset;

    public XMLBody(Message msg) {
        this.msg = msg;
        this.charset = msg.getCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        XMLStreamReader parser;
        out.writeAttribute("type", "xml");
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            parser = xmlInputFactory.createXMLStreamReader(this.msg.getBodyAsStreamDecoded(), this.charset);
        }
        boolean endDoc = false;
        block14: while (parser.hasNext()) {
            parser.next();
            switch (parser.getEventType()) {
                case 1: {
                    int i;
                    String localName = parser.getLocalName();
                    String namespaceURI = parser.getNamespaceURI();
                    if (namespaceURI != null && namespaceURI.length() > 0) {
                        String prefix = parser.getPrefix();
                        if (prefix != null) {
                            out.writeStartElement(prefix, localName, namespaceURI);
                        } else {
                            out.writeStartElement(namespaceURI, localName);
                        }
                    } else {
                        out.writeStartElement(localName);
                    }
                    int len = parser.getNamespaceCount();
                    for (i = 0; i < len; ++i) {
                        out.writeNamespace(parser.getNamespacePrefix(i), parser.getNamespaceURI(i));
                    }
                    len = parser.getAttributeCount();
                    for (i = 0; i < len; ++i) {
                        String attUri = parser.getAttributeNamespace(i);
                        if (attUri != null) {
                            out.writeAttribute(attUri, parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                            continue;
                        }
                        out.writeAttribute(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                    }
                    continue block14;
                }
                case 2: {
                    out.writeEndElement();
                    break;
                }
                case 4: 
                case 6: {
                    out.writeCharacters(parser.getTextCharacters(), parser.getTextStart(), parser.getTextLength());
                    break;
                }
                case 3: {
                    out.writeProcessingInstruction(parser.getPITarget(), parser.getPIData());
                    break;
                }
                case 12: {
                    out.writeCData(parser.getText());
                    break;
                }
                case 5: {
                    out.writeComment(parser.getText());
                    break;
                }
                case 9: {
                    out.writeEntityRef(parser.getLocalName());
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    endDoc = true;
                    break;
                }
            }
        }
        if (!endDoc) {
            throw new RuntimeException("XML document has not ended.");
        }
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

