/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="limit")
public class LimitInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger(LimitInterceptor.class);
    private long maxBodyLength = -1L;

    public LimitInterceptor() {
        this.name = "Limit Interceptor";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        return this.handleMessage(exc, exc.getResponse());
    }

    @Override
    public String getShortDescription() {
        return this.maxBodyLength == -1L ? "" : "Limit the length of message bodies to " + this.maxBodyLength + " bytes.";
    }

    public long getMaxBodyLength() {
        return this.maxBodyLength;
    }

    @MCAttribute
    public void setMaxBodyLength(long maxBodyLength) {
        this.maxBodyLength = maxBodyLength;
    }

    private Outcome handleMessage(Exchange exc, Message msg) throws IOException {
        if (this.maxBodyLength == -1L) {
            return Outcome.CONTINUE;
        }
        long len = msg.getHeader().getContentLength();
        if (len != -1L && len > this.maxBodyLength) {
            log.info("Message length (" + len + ") exceeded limit (" + this.maxBodyLength + ")");
            exc.setResponse(this.createFailureResponse());
            return Outcome.ABORT;
        }
        msg.setBody(new Body(new LengthLimitingStream(msg.getBodyAsStream())));
        return Outcome.CONTINUE;
    }

    private Response createFailureResponse() {
        return Response.badRequest("Message bodies must be smaller than " + this.maxBodyLength + " bytes.").build();
    }

    public class LengthLimitingStream
    extends InputStream {
        private final InputStream is;
        private long pos;

        public LengthLimitingStream(InputStream is) {
            this.is = is;
        }

        private void checkPosition() throws IOException {
            if (this.pos > LimitInterceptor.this.maxBodyLength) {
                log.info("Message length (>=" + this.pos + ") exceeded limit (" + LimitInterceptor.this.maxBodyLength + ")");
                throw new IOException("Message body too large.");
            }
        }

        @Override
        public int read() throws IOException {
            int i = this.is.read();
            if (i == -1) {
                return i;
            }
            ++this.pos;
            this.checkPosition();
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int l = this.is.read(b);
            if (l == -1) {
                return l;
            }
            this.pos += (long)l;
            this.checkPosition();
            return l;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int l = this.is.read(b, off, len);
            if (l == -1) {
                return l;
            }
            this.pos += (long)l;
            this.checkPosition();
            return l;
        }

        @Override
        public long skip(long n) throws IOException {
            long l = this.is.skip(n);
            if (l == -1L) {
                return l;
            }
            this.pos += l;
            this.checkPosition();
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        public String toString() {
            return "LengthLimitingStream(" + this.is.toString() + ")";
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

