/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="regExReplacer")
public class RegExReplaceInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)RegExReplaceInterceptor.class.getName());
    private String regex;
    private String replace;
    private TargetType target = TargetType.BODY;

    public RegExReplaceInterceptor() {
        this.name = "Regex Replacer";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        if (this.target == TargetType.HEADER) {
            this.replaceHeader(exc.getRequest().getHeader());
        } else {
            this.replaceBody(exc.getRequest());
        }
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) throws Exception {
        if (this.target == TargetType.HEADER) {
            this.replaceHeader(exc.getResponse().getHeader());
        } else {
            this.replaceBody(exc.getResponse());
        }
        return Outcome.CONTINUE;
    }

    private void replaceHeader(Header header) {
        for (HeaderField hf : header.getAllHeaderFields()) {
            hf.setValue(hf.getValue().replaceAll(this.regex, this.replace));
        }
    }

    private void replaceBody(Message res) throws IOException, Exception {
        if (res.getHeader().isBinaryContentType()) {
            return;
        }
        log.debug("pattern: " + this.regex);
        log.debug("replacement: " + this.replace);
        res.setBodyContent(res.getBodyAsStringDecoded().replaceAll(this.regex, this.replace).getBytes(res.getCharset()));
        res.getHeader().removeFields("Content-Encoding");
    }

    public String getRegex() {
        return this.regex;
    }

    @Required
    @MCAttribute
    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getReplace() {
        return this.replace;
    }

    @Required
    @MCAttribute
    public void setReplace(String replace) {
        this.replace = replace;
    }

    public TargetType getTarget() {
        return this.target;
    }

    @MCAttribute
    public void setTarget(TargetType target) {
        this.target = target;
    }

    public static enum TargetType {
        BODY,
        HEADER;

    }
}

