/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.interceptor.authentication.session.CleanupThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="accountBlocker")
public class AccountBlocker
extends AbstractXmlElement
implements CleanupThread.Cleaner {
    private static Logger log = LoggerFactory.getLogger((String)AccountBlocker.class.getName());
    private int blockWholeSystemAfter = 1000000;
    private int afterFailedLogins = 5;
    private long afterFailedLoginsWithin = Long.MAX_VALUE;
    private long blockFor = 3600000L;
    private HashMap<String, Info> users = new HashMap();

    @Override
    protected void parseAttributes(XMLStreamReader token) throws Exception {
        this.blockWholeSystemAfter = Integer.parseInt(StringUtils.defaultString((String)token.getAttributeValue("", "blockWholeSystemAfter"), (String)"1000000"));
        this.afterFailedLogins = Integer.parseInt(StringUtils.defaultString((String)token.getAttributeValue("", "afterFailedLogins"), (String)"5"));
        this.afterFailedLoginsWithin = Long.parseLong(StringUtils.defaultString((String)token.getAttributeValue("", "afterFailedLoginsWithin"), (String)"9223372036854775807"));
        this.blockFor = Integer.parseInt(StringUtils.defaultString((String)token.getAttributeValue("", "blockFor"), (String)"3600000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(String username) {
        Info info;
        HashMap<String, Info> hashMap = this.users;
        synchronized (hashMap) {
            if (this.users.size() == this.blockWholeSystemAfter) {
                log.error("There are " + this.blockWholeSystemAfter + " blocked user accounts. To avoid on OutOfMemoryError all accounts have been blocked.");
                return true;
            }
            info = this.users.get(username);
        }
        if (info == null) {
            return false;
        }
        return info.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(String username) {
        HashMap<String, Info> hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fail(String username) {
        Info info;
        Info info2 = new Info();
        HashMap<String, Info> hashMap = this.users;
        synchronized (hashMap) {
            info = this.users.get(username);
            if (info == null) {
                info = info2;
                if (this.users.size() < this.blockWholeSystemAfter) {
                    this.users.put(username, info);
                }
            }
        }
        info.fail();
        return info.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        ArrayList<String> removeUs = new ArrayList<String>();
        long death = System.currentTimeMillis() - this.afterFailedLoginsWithin;
        HashMap<String, Info> hashMap = this.users;
        synchronized (hashMap) {
            for (Map.Entry<String, Info> e : this.users.entrySet()) {
                if (e.getValue().hasRelevantInformation(death)) continue;
                removeUs.add(e.getKey());
            }
            for (String username : removeUs) {
                this.users.remove(username);
            }
        }
    }

    public int getBlockWholeSystemAfter() {
        return this.blockWholeSystemAfter;
    }

    @MCAttribute
    public void setBlockWholeSystemAfter(int blockWholeSystemAfter) {
        this.blockWholeSystemAfter = blockWholeSystemAfter;
    }

    public int getAfterFailedLogins() {
        return this.afterFailedLogins;
    }

    @MCAttribute
    public void setAfterFailedLogins(int afterFailedLogins) {
        this.afterFailedLogins = afterFailedLogins;
    }

    public long getAfterFailedLoginsWithin() {
        return this.afterFailedLoginsWithin;
    }

    @MCAttribute
    public void setAfterFailedLoginsWithin(long afterFailedLoginsWithin) {
        this.afterFailedLoginsWithin = afterFailedLoginsWithin;
    }

    public long getBlockFor() {
        return this.blockFor;
    }

    @MCAttribute
    public void setBlockFor(long blockFor) {
        this.blockFor = blockFor;
    }

    private class Info {
        private final long[] tries;
        private int current = 0;
        private long blockedUntil;

        public Info() {
            this.tries = new long[AccountBlocker.this.afterFailedLogins - 1];
        }

        public synchronized boolean isBlocked() {
            if (this.blockedUntil == 0L) {
                return false;
            }
            return System.currentTimeMillis() < this.blockedUntil;
        }

        private synchronized void fail() {
            ++this.current;
            this.current %= this.tries.length;
            long firstFail = this.tries[this.current];
            long now = this.tries[this.current] = System.currentTimeMillis();
            if (firstFail == 0L) {
                return;
            }
            if (now - firstFail < AccountBlocker.this.afterFailedLoginsWithin) {
                this.blockedUntil = now + AccountBlocker.this.blockFor;
            }
        }

        public synchronized boolean hasRelevantInformation(long death) {
            return this.tries[this.current] > death;
        }
    }
}

