/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.authorizationservice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.oauth2.ClaimRenamer;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.AuthorizationService;
import com.predic8.membrane.core.interceptor.oauth2.authorizationservice.DynamicRegistration;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;

@MCElement(name="membrane")
public class MembraneAuthorizationService
extends AuthorizationService {
    private String src;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String subject = ClaimRenamer.convert("sub");
    private String authorizationEndpoint;
    private String publicAuthorizationEndpoint;
    private String revocationEndpoint;
    private String registrationEndpoint;
    private String jwksEndpoint;
    private String claims;
    private String claimsIdt;
    private String claimsParameter;
    private String callbackUri;
    private DynamicRegistration dynamicRegistration;
    private static final String defaultCallbackUri = "oauth2callback";

    @Override
    public void init() throws Exception {
        if (this.src == null) {
            throw new Exception("No wellknown file source configured. - Cannot work without one");
        }
        if (this.dynamicRegistration != null) {
            this.dynamicRegistration.init(this.router);
            this.supportsDynamicRegistration = true;
        }
        try {
            String[] urls = this.src.split(Pattern.quote(" "));
            if (urls.length == 1) {
                String url = urls[0] + "/.well-known/openid-configuration";
                this.parseSrc(this.dynamicRegistration != null ? this.dynamicRegistration.retrieveOpenIDConfiguration(url) : this.router.getResolverMap().resolve(url));
            } else if (urls.length == 2) {
                String internalUrl = urls[1] + "/.well-known/openid-configuration";
                this.parseSrc(this.dynamicRegistration != null ? this.dynamicRegistration.retrieveOpenIDConfiguration(internalUrl) : this.router.getResolverMap().resolve(internalUrl));
                this.publicAuthorizationEndpoint = urls[0] + new URI(this.authorizationEndpoint).getPath();
            } else if (urls.length > 2) {
                throw new RuntimeException("src property is not set correctly: " + this.src);
            }
        }
        catch (ResourceRetrievalException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.adjustScope();
        this.prepareClaimsForLoginUrl();
    }

    @Override
    public String getIssuer() {
        return this.src;
    }

    @Override
    public String getJwksEndpoint() throws Exception {
        return this.jwksEndpoint;
    }

    @Override
    protected void doDynamicRegistration(Exchange exc, String publicURL) throws Exception {
        if (this.clientId != null && this.clientSecret != null) {
            return;
        }
        if (this.dynamicRegistration == null || this.registrationEndpoint == null || this.registrationEndpoint.isEmpty()) {
            throw new RuntimeException("A registration bean is required and src needs to specify a registration endpoint");
        }
        this.createCallbackUri(exc, publicURL);
        this.dynamicRegistrationIfNeeded();
    }

    private void createCallbackUri(Exchange exc, String publicURL) {
        this.callbackUri = publicURL + defaultCallbackUri;
    }

    private void dynamicRegistrationIfNeeded() throws Exception {
        this.setClientIdAndSecret(this.dynamicRegistration.registerWithCallbackAt(this.callbackUri, this.registrationEndpoint));
    }

    private void setClientIdAndSecret(Client client) {
        this.clientId = client.getClientId();
        this.clientSecret = client.getClientSecret();
    }

    private void prepareClaimsForLoginUrl() throws IOException {
        this.claimsParameter = ClaimsParameter.writeCompleteJson(this.claims, this.claimsIdt);
        if (this.claimsParameter.isEmpty()) {
            this.claimsParameter = null;
        }
    }

    private void adjustScope() throws UnsupportedEncodingException {
        if (this.scope == null) {
            this.scope = "profile";
        }
        this.scope = OAuth2Util.urlencode(this.scope);
    }

    private void parseSrc(InputStream resolve) throws IOException {
        String file = IOUtils.toString((InputStream)resolve);
        ObjectMapper mapper = new ObjectMapper();
        Map json = (Map)mapper.readValue(file, Map.class);
        this.tokenEndpoint = (String)json.get("token_endpoint");
        this.userInfoEndpoint = (String)json.get("userinfo_endpoint");
        this.authorizationEndpoint = (String)json.get("authorization_endpoint");
        this.revocationEndpoint = (String)json.get("revocation_endpoint");
        this.registrationEndpoint = (String)json.get("registration_endpoint");
        this.jwksEndpoint = (String)json.get("jwks_uri");
    }

    @Override
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    @Override
    public String getLoginURL(String securityToken, String publicURL, String pathQuery) {
        String endpoint = this.publicAuthorizationEndpoint;
        if (endpoint == null) {
            endpoint = this.authorizationEndpoint;
        }
        return endpoint + "?client_id=" + this.getClientId() + "&response_type=code&scope=" + this.scope + "&redirect_uri=" + publicURL + "oauth2callback&state=security_token%3D" + securityToken + "%26url%3D" + pathQuery + this.getClaimsParameter();
    }

    private String getClaimsParameter() {
        if (this.claimsParameter == null) {
            return "";
        }
        try {
            return "&claims=" + OAuth2Util.urlencode(this.claimsParameter);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @MCAttribute
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSrc() {
        return this.src;
    }

    @Required
    @MCAttribute
    public void setSrc(String src) {
        this.src = src;
    }

    public String getClaims() {
        return this.claims;
    }

    @MCAttribute
    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getClaimsIdt() {
        return this.claimsIdt;
    }

    @MCAttribute
    public void setClaimsIdt(String claimsIdt) {
        this.claimsIdt = claimsIdt;
    }

    public DynamicRegistration getDynamicRegistration() {
        return this.dynamicRegistration;
    }

    @MCChildElement(order=10)
    public void setDynamicRegistration(DynamicRegistration dynamicRegistration) {
        this.dynamicRegistration = dynamicRegistration;
    }
}

