/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.oauth2.request;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.authentication.session.SessionManager;
import com.predic8.membrane.core.interceptor.oauth2.Client;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2AuthorizationServerInterceptor;
import com.predic8.membrane.core.interceptor.oauth2.OAuth2Util;
import com.predic8.membrane.core.interceptor.oauth2.parameter.ClaimsParameter;
import com.predic8.membrane.core.interceptor.oauth2.request.NoResponse;
import com.predic8.membrane.core.interceptor.oauth2.request.ParameterizedRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;

public class AuthWithoutSessionRequest
extends ParameterizedRequest {
    public AuthWithoutSessionRequest(OAuth2AuthorizationServerInterceptor authServer, Exchange exc) throws Exception {
        super(authServer, exc);
    }

    @Override
    protected Response checkForMissingParameters() throws Exception {
        if (this.getClientId() == null || this.getRedirectUri() == null) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        if (this.getResponseType() == null || this.getScope() == null) {
            return this.createParameterizedFormUrlencodedRedirect(this.exc, this.getState(), this.getRedirectUri() + "?error=invalid_request");
        }
        return new NoResponse();
    }

    @Override
    protected Response processWithParameters() throws Exception {
        Client client;
        try {
            client = this.authServer.getClientList().getClient(this.getClientId());
        }
        catch (Exception e) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "unauthorized_client");
        }
        if (!OAuth2Util.isAbsoluteUri(this.getRedirectUri()) || !this.getRedirectUri().equals(client.getCallbackUrl())) {
            return OAuth2Util.createParameterizedJsonErrorResponse(this.exc, this.jsonGen, "error", "invalid_request");
        }
        if (this.promptEqualsNone()) {
            return this.createParameterizedFormUrlencodedRedirect(this.exc, this.getState(), client.getCallbackUrl() + "?error=login_required");
        }
        if (!this.authServer.getSupportedAuthorizationGrants().contains(this.getResponseType())) {
            return this.createParameterizedFormUrlencodedRedirect(this.exc, this.getState(), client.getCallbackUrl() + "?error=unsupported_response_type");
        }
        String validScopes = this.verifyScopes(this.getScope());
        if (validScopes.isEmpty()) {
            return this.createParameterizedFormUrlencodedRedirect(this.exc, this.getState(), client.getCallbackUrl() + "?error=invalid_scope");
        }
        if (OAuth2Util.isOpenIdScope(validScopes)) {
            if (!this.isCodeRequest()) {
                return this.createParameterizedFormUrlencodedRedirect(this.exc, this.getState(), client.getCallbackUrl() + "?error=invalid_request");
            }
            this.addValidClaimsToParams();
        } else {
            this.removeClaimsWhenNotOpenidScope();
        }
        this.setScope(validScopes);
        String invalidScopes = this.hasGivenInvalidScopes(this.getScope(), validScopes);
        if (!invalidScopes.isEmpty()) {
            this.setScopeInvalid(invalidScopes);
        }
        SessionManager.Session session = this.authServer.getSessionManager().getOrCreateSession(this.exc);
        this.addParams(session, this.params);
        return new NoResponse();
    }

    private void removeClaimsWhenNotOpenidScope() {
        this.params.remove("claims");
    }

    private void addValidClaimsToParams() throws IOException {
        ClaimsParameter claims;
        if (this.getClaims() != null && (claims = new ClaimsParameter(this.authServer.getClaimList().getSupportedClaims(), this.getClaims())).hasClaims()) {
            this.params.put("claims", claims.toJson());
        }
    }

    private boolean isCodeRequest() {
        return this.getResponseType().equals("code");
    }

    private boolean promptEqualsNone() {
        return this.getPrompt() != null && this.getPrompt().equals("none");
    }

    @Override
    protected Response getResponse() throws Exception {
        return this.redirectToLogin();
    }

    protected String verifyScopes(String scopes) {
        String[] scopeList = scopes.split(" ");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < scopeList.length; ++i) {
            if (!this.authServer.getClaimList().scopeExists(scopeList[i])) continue;
            builder.append(scopeList[i]).append(" ");
        }
        return builder.toString().trim();
    }

    protected String hasGivenInvalidScopes(String givenScopes, String validScopes) {
        HashSet<String> valid = new HashSet<String>(Arrays.asList(validScopes.split(" ")));
        StringBuilder builder = new StringBuilder();
        for (String scope : new HashSet<String>(Arrays.asList(givenScopes.split(" ")))) {
            if (valid.contains(scope)) continue;
            builder.append(scope).append(" ");
        }
        return builder.toString().trim();
    }

    protected Response redirectToLogin() throws MalformedURLException, UnsupportedEncodingException {
        Response resp = Response.redirect(this.authServer.getPath(), false).dontCache().body("").build();
        return resp;
    }
}

