/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.rest;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.xml.Request;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="http2xml")
public class HTTP2XMLInterceptor
extends AbstractInterceptor {
    private static Logger log = LoggerFactory.getLogger((String)HTTP2XMLInterceptor.class.getName());

    public HTTP2XMLInterceptor() {
        this.name = "HTTP 2 XML";
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        log.debug("uri: " + exc.getRequest().getUri());
        String res = new Request(exc.getRequest()).toXml();
        log.debug("http-xml: " + res);
        exc.getRequest().setBodyContent(res.getBytes("UTF-8"));
        exc.getRequest().setMethod("POST");
        exc.getRequest().getHeader().setSOAPAction("");
        return Outcome.CONTINUE;
    }
}

