/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.schemavalidation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.schemavalidation.IValidator;
import com.predic8.membrane.core.interceptor.schemavalidation.ValidatorInterceptor;
import com.predic8.membrane.core.resolver.ResolverMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class JSONValidator
implements IValidator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private JsonSchema schema;
    private final ResolverMap resourceResolver;
    private final String jsonSchema;
    private final ValidatorInterceptor.FailureHandler failureHandler;
    private final AtomicLong valid = new AtomicLong();
    private final AtomicLong invalid = new AtomicLong();

    public JSONValidator(ResolverMap resourceResolver, String jsonSchema, ValidatorInterceptor.FailureHandler failureHandler) throws IOException {
        this.resourceResolver = resourceResolver;
        this.jsonSchema = jsonSchema;
        this.failureHandler = failureHandler;
        this.createValidators();
    }

    @Override
    public Outcome validateMessage(Exchange exc, Message msg, String source) throws Exception {
        return this.validateMessage(exc, msg.getBodyAsStreamDecoded(), Charset.forName(msg.getCharset()), source);
    }

    public Outcome validateMessage(Exchange exc, InputStream body, Charset charset, String source) throws Exception {
        ArrayList<String> errors;
        boolean success = true;
        try {
            JsonNode node = JsonLoader.fromReader((Reader)new InputStreamReader(body, charset));
            ProcessingReport report = this.schema.validateUnchecked(node);
            success = report.isSuccess();
            errors = new ArrayList();
            Iterator iterator = report.iterator();
            while (iterator.hasNext()) {
                ProcessingMessage processingMessage = (ProcessingMessage)iterator.next();
                errors.add(processingMessage.getMessage());
            }
        }
        catch (JsonParseException e) {
            success = false;
            errors = new ArrayList<String>();
            errors.add(e.getMessage());
        }
        if (success) {
            this.valid.incrementAndGet();
            return Outcome.CONTINUE;
        }
        if (this.failureHandler == ValidatorInterceptor.FailureHandler.VOID) {
            StringBuilder message = new StringBuilder();
            message.append(source);
            message.append(": ");
            for (String error : errors) {
                message.append(error);
                message.append(";");
            }
            exc.setProperty("error", message.toString());
            this.invalid.incrementAndGet();
            return Outcome.ABORT;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator jg = new JsonFactory().createGenerator((OutputStream)baos);
        jg.writeStartObject();
        jg.writeStringField("source", source);
        jg.writeArrayFieldStart("errors");
        for (String string : errors) {
            jg.writeString(string);
        }
        jg.close();
        if (this.failureHandler != null) {
            this.failureHandler.handleFailure(new String(baos.toByteArray(), UTF8), exc);
            exc.setResponse(Response.badRequest().contentType("application/json;charset=utf-8").body("{\"error\":\"error\"}".getBytes(UTF8)).build());
        } else {
            exc.setResponse(Response.badRequest().contentType("application/json;charset=utf-8").body(baos.toByteArray()).build());
        }
        this.invalid.incrementAndGet();
        return Outcome.ABORT;
    }

    private void createValidators() throws IOException {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonNode schemaNode = JsonLoader.fromReader((Reader)new InputStreamReader(this.resourceResolver.resolve(this.jsonSchema)));
        try {
            this.schema = factory.getJsonSchema(schemaNode);
        }
        catch (ProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getValid() {
        return this.valid.get();
    }

    @Override
    public long getInvalid() {
        return this.invalid.get();
    }
}

