/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.swagger;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.Path;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.swagger.ApiKeyTransmissionStrategy;
import com.predic8.membrane.core.interceptor.swagger.ApiKeyValidator;
import com.predic8.membrane.core.rules.ServiceProxy;

@MCElement(name="apiKeyChecker")
public class ApiKeyCheckerInterceptor
extends AbstractInterceptor {
    boolean allowSwagger;
    ApiKeyValidator apiKeyValidator;
    ApiKeyTransmissionStrategy apiKeyTransmissionStrategy;

    @Override
    public void init(Router router) throws Exception {
        super.init(router);
        this.apiKeyValidator.init(router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) throws Exception {
        String currentKey;
        if (this.allowSwagger) {
            Path path1;
            String path = exc.getRequest().getUri();
            if (exc.getRule() instanceof ServiceProxy && (path1 = ((ServiceProxy)exc.getRule()).getPath()) != null && !path1.isRegExp() && path.startsWith(path1.getValue())) {
                path = path.substring(path1.getValue().length());
            }
            if (path.equals("/swagger-ui.html") || path.startsWith("/swagger-resources") || path.startsWith("/webjars/springfox-swagger-ui") || path.equals("/v2/api-docs")) {
                return Outcome.CONTINUE;
            }
        }
        if ((currentKey = this.apiKeyTransmissionStrategy.getApiKey(exc.getRequest())) == null || !this.apiKeyValidator.isValid(currentKey)) {
            exc.setResponse(Response.unauthorized("Api Key is missing").build());
            return Outcome.RETURN;
        }
        return super.handleRequest(exc);
    }

    public ApiKeyValidator getApiKeyValidator() {
        return this.apiKeyValidator;
    }

    @MCChildElement(order=10)
    public void setApiKeyValidator(ApiKeyValidator apiKeyValidator) {
        this.apiKeyValidator = apiKeyValidator;
    }

    public ApiKeyTransmissionStrategy getApiKeyTransmissionStrategy() {
        return this.apiKeyTransmissionStrategy;
    }

    @MCChildElement(order=20)
    public void setApiKeyTransmissionStrategy(ApiKeyTransmissionStrategy apiKeyTransmissionStrategy) {
        this.apiKeyTransmissionStrategy = apiKeyTransmissionStrategy;
    }

    public boolean isAllowSwagger() {
        return this.allowSwagger;
    }

    @MCAttribute
    public void setAllowSwagger(boolean allowSwagger) {
        this.allowSwagger = allowSwagger;
    }
}

