/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.ws_addressing;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.ws_addressing.DecoupledEndpointRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DecoupledEndpointRewriter {
    private static final String ADDRESSING_URI = "http://www.w3.org/2005/08/addressing";
    private final DocumentBuilderFactory builderFactory;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final DecoupledEndpointRegistry registry;

    public DecoupledEndpointRewriter(DecoupledEndpointRegistry registry) {
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
        this.registry = registry;
    }

    public void rewriteToElement(InputStream reader, OutputStream output, Exchange exc) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Document doc = this.getDocument(reader);
        String uri = this.getRelatesToValue(doc);
        this.setTarget(exc, uri);
        this.setToElement(doc, uri);
        this.writeDocument(output, doc);
    }

    private void setTarget(Exchange exc, String uri) {
        exc.getDestinations().set(0, this.registry.lookup(uri));
    }

    private void writeDocument(OutputStream output, Document doc) throws TransformerException {
        this.transformerFactory.newTransformer().transform(new DOMSource(doc), new StreamResult(output));
    }

    private Document getDocument(InputStream reader) throws SAXException, IOException, ParserConfigurationException {
        return this.builderFactory.newDocumentBuilder().parse(reader);
    }

    private void setToElement(Document doc, String relatesTo) {
        doc.getElementsByTagNameNS(ADDRESSING_URI, "To").item(0).setTextContent(this.registry.lookup(relatesTo));
    }

    private String getRelatesToValue(Document doc) {
        return doc.getElementsByTagNameNS(ADDRESSING_URI, "RelatesTo").item(0).getTextContent();
    }
}

