/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.xmlcontentfilter;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

@ThreadSafe
public class XMLElementFinder {
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final HashSet<QName> elements = new HashSet();
    private final boolean usesWildcardNamespace;

    public XMLElementFinder(List<QName> elements) {
        boolean usesWildcardNamespace = false;
        for (QName element : elements) {
            this.elements.add(element);
            if (element.getNamespaceURI() != "") continue;
            usesWildcardNamespace = true;
        }
        this.usesWildcardNamespace = usesWildcardNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(InputStream is) {
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(is);
            }
            while (parser.hasNext()) {
                QName onlyLocal;
                XMLEvent event = parser.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = (StartElement)event;
                if (this.elements.contains(startElement.getName())) {
                    return true;
                }
                if (!this.usesWildcardNamespace || !this.elements.contains(onlyLocal = new QName(startElement.getName().getLocalPart()))) continue;
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

