/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.lang;

import com.google.common.base.Function;
import com.predic8.membrane.core.Router;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptExecutorPool<T, R>
implements Function<Map<String, Object>, R> {
    private static final Logger log = LoggerFactory.getLogger(ScriptExecutorPool.class);
    private static final int concurrency = Runtime.getRuntime().availableProcessors() * 2;
    ArrayBlockingQueue<T> scripts = new ArrayBlockingQueue(concurrency);

    public void init(Router router) {
        this.scripts.add(this.createOneScript());
        router.getBackgroundInitializator().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 1; i < concurrency; ++i) {
                        ScriptExecutorPool.this.scripts.add(ScriptExecutorPool.this.createOneScript());
                    }
                }
                catch (Exception e) {
                    log.error("Error compiling script:", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object execute(Map<String, Object> parameters) {
        Object object;
        T script = this.scripts.take();
        try {
            object = this.invoke(script, parameters);
        }
        catch (Throwable throwable) {
            try {
                this.scripts.put(script);
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.scripts.put(script);
        return object;
    }

    protected abstract Object invoke(T var1, Map<String, Object> var2);

    protected abstract T createOneScript();
}

