/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ws;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFrame {
    protected static Logger log = LoggerFactory.getLogger((String)WebSocketFrame.class.getName());
    static final int INITIAL_BUFFER_SIZE = 8192;
    Exchange originalExchange;
    private String error = null;
    boolean finalFragment;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;
    int opcode;
    boolean isMasked;
    long payloadLength;
    final byte[] maskKey = new byte[4];
    byte[] payload = new byte[8192];

    public WebSocketFrame() {
    }

    public WebSocketFrame(boolean fin, boolean rsv1, boolean rsv2, boolean rsv3, int opcode, boolean isMasked, byte[] maskingKey, byte[] payload) {
        this.finalFragment = fin;
        this.rsv1 = rsv1;
        this.rsv2 = rsv2;
        this.rsv3 = rsv3;
        this.opcode = opcode;
        this.isMasked = isMasked;
        this.payloadLength = payload.length;
        System.arraycopy(this.maskKey, 0, maskingKey, 0, maskingKey.length);
        System.arraycopy(this.payload, 0, payload, 0, payload.length);
    }

    private String calcError() {
        if (this.payloadLength < 2L) {
            throw new IllegalStateException("Error code not read.");
        }
        return String.valueOf(ByteBuffer.wrap(this.payload, 0, 2).getShort());
    }

    public void write(OutputStream out) throws IOException {
        byte[] result = new byte[this.getSizeInBytes()];
        byte finAndReservedAndOpcode = 0;
        finAndReservedAndOpcode = ByteUtil.setBitValueBigEndian(finAndReservedAndOpcode, 0, this.finalFragment);
        finAndReservedAndOpcode = ByteUtil.setBitValueBigEndian(finAndReservedAndOpcode, 1, this.rsv1);
        finAndReservedAndOpcode = ByteUtil.setBitValueBigEndian(finAndReservedAndOpcode, 2, this.rsv2);
        finAndReservedAndOpcode = ByteUtil.setBitValueBigEndian(finAndReservedAndOpcode, 3, this.rsv3);
        finAndReservedAndOpcode = ByteUtil.setBitValuesBigEndian(finAndReservedAndOpcode, 4, 7, this.opcode);
        byte maskAndPayloadLength = 0;
        maskAndPayloadLength = ByteUtil.setBitValueBigEndian(maskAndPayloadLength, 0, this.isMasked);
        int additionalPayloadBytes = this.getExtendedPayloadSize(this.computePayloadField());
        maskAndPayloadLength = ByteUtil.setBitValuesBigEndian(maskAndPayloadLength, 1, 7, this.computePayloadField());
        result[0] = finAndReservedAndOpcode;
        result[1] = maskAndPayloadLength;
        byte[] additionalPayloadLength = null;
        if (additionalPayloadBytes == 2) {
            byte[] extendedPayloadLength = ByteBuffer.allocate(4).putInt((int)this.payloadLength).array();
            byte[] correctedExtendedPayloadLength = new byte[2];
            for (int i = 2; i < extendedPayloadLength.length; ++i) {
                correctedExtendedPayloadLength[i - 2] = extendedPayloadLength[i];
            }
            additionalPayloadLength = correctedExtendedPayloadLength;
        }
        if (additionalPayloadBytes == 8) {
            additionalPayloadLength = ByteBuffer.allocate(8).putLong((int)this.payloadLength).array();
        }
        if (additionalPayloadLength != null) {
            for (int i = 0; i < additionalPayloadBytes; ++i) {
                result[2 + i] = additionalPayloadLength[i];
            }
        }
        int maskKeyLength = this.isMasked ? this.maskKey.length : 0;
        for (int i = 0; i < maskKeyLength; ++i) {
            result[2 + additionalPayloadBytes + i] = this.maskKey[i];
        }
        int payloadOffset = 2 + additionalPayloadBytes + maskKeyLength;
        System.arraycopy(this.payload, 0, result, payloadOffset, (int)this.payloadLength);
        if (this.isMasked) {
            int maskIndex = 0;
            int i = 0;
            while ((long)i < this.payloadLength) {
                result[payloadOffset + i] = (byte)(result[payloadOffset + i] ^ this.maskKey[maskIndex]);
                maskIndex = (maskIndex + 1) % 4;
                ++i;
            }
        }
        out.write(result);
        out.flush();
    }

    private int computePayloadField() {
        if (this.payloadLength <= 125L) {
            return (int)this.payloadLength;
        }
        if (this.payloadLength < 65536L) {
            return 126;
        }
        return 127;
    }

    private int getExtendedPayloadSize(int size) {
        if (size >= 126) {
            if (size == 126) {
                return 2;
            }
            return 8;
        }
        return 0;
    }

    private int getSizeInBytes() {
        return 2 + this.getExtendedPayloadSize(this.computePayloadField()) + (this.isMasked ? this.maskKey.length : 0) + (this.payload != null ? (int)this.payloadLength : 0);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public boolean isMasked() {
        return this.isMasked;
    }

    public void setMasked(boolean masked) {
        this.isMasked = masked;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(long payloadLength) {
        this.payloadLength = payloadLength;
    }

    public byte[] getMaskKey() {
        return this.maskKey;
    }

    public void setMaskKey(byte[] maskKey) {
        if (maskKey.length != 4) {
            throw new IllegalArgumentException("maskKey must have length 4.");
        }
        System.arraycopy(maskKey, 0, this.maskKey, 0, 4);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        this.payloadLength = payload.length;
    }

    public int tryRead(byte[] buffer, int offset, int length) {
        int i;
        if (length < 2) {
            return 0;
        }
        int origOffset = offset;
        byte finAndReservedAndOpCode = buffer[offset++];
        this.finalFragment = ByteUtil.getBitValueBigEndian(finAndReservedAndOpCode, 0);
        this.rsv1 = ByteUtil.getBitValueBigEndian(finAndReservedAndOpCode, 1);
        this.rsv2 = ByteUtil.getBitValueBigEndian(finAndReservedAndOpCode, 2);
        this.rsv3 = ByteUtil.getBitValueBigEndian(finAndReservedAndOpCode, 3);
        this.opcode = ByteUtil.getValueOfBits(finAndReservedAndOpCode, 4, 7);
        int headerLength = 2;
        byte maskAndPayloadLength = buffer[offset++];
        this.isMasked = ByteUtil.getBitValueBigEndian(maskAndPayloadLength, 0);
        this.payloadLength = ByteUtil.getValueOfBits(maskAndPayloadLength, 1, 7);
        if (this.payloadLength >= 126L) {
            byte[] newPayloadLength;
            if (this.payloadLength == 126L) {
                headerLength += 2;
                newPayloadLength = new byte[4];
                for (i = 2; i < newPayloadLength.length; ++i) {
                    newPayloadLength[i] = buffer[offset++];
                }
                this.payloadLength = ByteBuffer.wrap(newPayloadLength).getInt();
            } else {
                headerLength += 8;
                newPayloadLength = new byte[8];
                for (i = 0; i < newPayloadLength.length; ++i) {
                    newPayloadLength[i] = buffer[offset++];
                }
                this.payloadLength = ByteBuffer.wrap(newPayloadLength).getLong();
            }
        }
        if (this.isMasked) {
            headerLength += 4;
            for (int i2 = 0; i2 < 4; ++i2) {
                this.maskKey[i2] = buffer[offset++];
            }
        }
        if (this.payloadLength > Integer.MAX_VALUE || this.payloadLength < 0L) {
            log.warn("Payload of ws message is bigger than Integer.MAX_VALUE which is currently not supported. Message will be truncated");
            this.payloadLength = Integer.MAX_VALUE;
        }
        if (this.payloadLength > (long)(length - headerLength)) {
            return 0;
        }
        if ((long)this.payload.length < this.payloadLength) {
            this.payload = new byte[(int)this.payloadLength];
        }
        int maskIndex = 0;
        i = 0;
        while ((long)i < this.payloadLength) {
            this.payload[i] = buffer[offset++];
            if (this.isMasked) {
                this.payload[i] = (byte)(this.payload[i] ^ this.maskKey[maskIndex]);
            }
            maskIndex = (maskIndex + 1) % 4;
            ++i;
        }
        if (this.opcode == 8) {
            this.error = this.calcError();
        }
        return offset - origOffset;
    }

    public String toString() {
        return "WebSocketFrame{error='" + this.error + '\'' + ", finalFragment=" + this.finalFragment + ", rsv1=" + this.rsv1 + ", rsv2=" + this.rsv2 + ", rsv3=" + this.rsv3 + ", opcode=" + this.opcode + ", isMasked=" + this.isMasked + ", payloadLength=" + this.payloadLength + (this.isMasked ? ", maskKey=" + Arrays.toString(this.maskKey) : "") + ", payload=" + (this.opcode == 8 ? new String(this.payload, 2, (int)this.payloadLength - 2) : new String(this.payload, 0, (int)this.payloadLength)) + '}';
    }

    private String toHex(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (offset + length > buffer.length) {
            throw new IllegalArgumentException();
        }
        int i = -1;
        StringBuffer total = new StringBuffer();
        StringBuffer hex = new StringBuffer();
        StringBuffer ascii = new StringBuffer();
        do {
            int b;
            if ((b = buffer[offset + ++i]) < 32 || b >= 128) {
                ascii.append('.');
            } else {
                ascii.append((char)b);
            }
            for (int d = 0; d < 2; ++d) {
                int e = b;
                if (e < 0) {
                    e += 256;
                }
                e = (d == 0 ? e / 16 : e) % 16;
                hex.append((char)(e < 10 ? e + 48 : e - 10 + 65));
            }
            if (i % 2 == 1) {
                hex.append(' ');
            }
            if (i == length - 1) {
                while (hex.length() < 40) {
                    hex.append(' ');
                }
            }
            if (i % 16 != 15 && i != length - 1) continue;
            total.append(hex.toString());
            total.append(' ');
            total.append(ascii.toString());
            total.append('\n');
            hex.delete(0, hex.length());
            ascii.delete(0, ascii.length());
        } while (i != length - 1);
        return total.toString();
    }

    public String toStringHex() {
        return "WebSocketFrame{error='" + this.error + '\'' + ", finalFragment=" + this.finalFragment + ", rsv1=" + this.rsv1 + ", rsv2=" + this.rsv2 + ", rsv3=" + this.rsv3 + ", opcode=" + this.opcode + ", isMasked=" + this.isMasked + ", payloadLength=" + this.payloadLength + (this.isMasked ? ", maskKey=" + Arrays.toString(this.maskKey) : "") + ", payload=\n" + (this.opcode == 8 ? this.toHex(this.payload, 2, (int)this.payloadLength - 2) : this.toHex(this.payload, 0, (int)this.payloadLength)) + '}';
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public Exchange getOriginalExchange() {
        return this.originalExchange;
    }

    public void setOriginalExchange(Exchange originalExchange) {
        this.originalExchange = originalExchange;
    }
}

