/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class MapNamespaceContext
implements NamespaceContext {
    private Map<String, String> namespaces;

    public MapNamespaceContext(Map<String, String> namespaces) {
        this.namespaces = namespaces;
        this.addDefaultNamespaces();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (this.namespaces.containsKey(prefix)) {
            return this.namespaces.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
            if (!e.getValue().equals(namespaceURI)) continue;
            return e.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
            if (!e.getValue().equals(namespaceURI)) continue;
            l.add(e.getKey());
        }
        return l.iterator();
    }

    private void addDefaultNamespaces() {
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xmlns", "http://www.w3.org/2000/xmlns/");
        if (!this.namespaces.containsKey("")) {
            this.namespaces.put("", "");
        }
    }
}

