/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.util.URI;
import java.net.URISyntaxException;

@MCElement(name="uriFactory")
public class URIFactory {
    private boolean allowIllegalCharacters;
    private boolean autoEscapeBackslashes = true;

    public URIFactory() {
        this(false);
    }

    public URIFactory(boolean allowIllegalCharacters) {
        this.allowIllegalCharacters = allowIllegalCharacters;
    }

    public boolean isAllowIllegalCharacters() {
        return this.allowIllegalCharacters;
    }

    @MCAttribute
    public void setAllowIllegalCharacters(boolean allowIllegalCharacters) {
        this.allowIllegalCharacters = allowIllegalCharacters;
    }

    public boolean isAutoEscapeBackslashes() {
        return this.autoEscapeBackslashes;
    }

    @MCAttribute
    public void setAutoEscapeBackslashes(boolean autoEscapeBackslashes) {
        this.autoEscapeBackslashes = autoEscapeBackslashes;
    }

    public URI create(String uri) throws URISyntaxException {
        if (this.autoEscapeBackslashes && uri.contains("\\")) {
            uri = uri.replaceAll("\\\\", "%5C");
        }
        return new URI(this.allowIllegalCharacters, uri);
    }

    public URI createWithoutException(String uri) {
        if (this.autoEscapeBackslashes && uri.contains("\\")) {
            uri = uri.replaceAll("\\\\", "%5C");
        }
        try {
            return new URI(this.allowIllegalCharacters, uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

