/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfiguredRMFailoverHAProxy<T>
implements RMFailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredRMFailoverHAProxy.class);
    private T currentProxty;
    private String currentRMId;
    Map<String, T> oldProxies = new HashMap<String, T>();
    private RMProxy<T> rmProxy;
    private Class<T> protocol;
    protected YarnConfiguration conf;
    protected String[] rmServiceIds;

    @Override
    public void init(Configuration configuration, RMProxy<T> rmProxy, Class<T> protocol) {
        this.rmProxy = rmProxy;
        this.protocol = protocol;
        this.rmProxy.checkAllowedProtocols(this.protocol);
        this.conf = new YarnConfiguration(configuration);
        Collection rmIds = HAUtil.getRMHAIds((Configuration)this.conf);
        this.rmServiceIds = rmIds.toArray(new String[rmIds.size()]);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.client.failover-retries", 0));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        return new FailoverProxyProvider.ProxyInfo(this.currentProxty, this.currentRMId);
    }

    public synchronized void performFailover(T currentProxy) {
        this.oldProxies.put(this.currentRMId, currentProxy);
        this.conf.set("yarn.resourcemanager.ha.id", this.currentRMId);
        LOG.info((Object)("Failing over to " + this.currentRMId));
    }

    public Class<T> getInterface() {
        return this.protocol;
    }

    public synchronized void close() throws IOException {
        for (T proxy : this.oldProxies.values()) {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                continue;
            }
            RPC.stopProxy(proxy);
        }
    }
}

