/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.exception.StorageException;
import io.hops.exception.UniqueKeyConstraintViolationException;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.hdfs.entity.User;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
@VisibleForTesting
class UsersGroupsCache {
    private final Log LOG = LogFactory.getLog(UsersGroupsCache.class);
    private LoadingCache<String, List<String>> userToGroupsCache;
    private LoadingCache<Integer, String> idToUserCache;
    private LoadingCache<String, Integer> userToIdCache;
    private LoadingCache<Integer, String> idToGroupCache;
    private LoadingCache<String, Integer> groupToIdCache;
    private CacheLoader<String, List<String>> userToGroupsLoader = new CacheLoader<String, List<String>>(){

        public List<String> load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get groups from DB for user=" + userName));
            List groups = UsersGroupsCache.this.getGroupsFromDB(userName, UsersGroupsCache.this.getUserId(userName));
            if (groups == null || groups.isEmpty()) {
                throw new GroupsNotFoundForUserException("No groups found for user (" + userName + ")");
            }
            ArrayList groupNames = Lists.newArrayListWithExpectedSize((int)groups.size());
            for (Group group : groups) {
                groupNames.add(group.getName());
                UsersGroupsCache.this.addGroupToCache(group.getId(), group.getName());
            }
            return groupNames;
        }
    };
    private RemovalListener<String, List<String>> userToGroupsRemoval = new RemovalListener<String, List<String>>(){

        public void onRemoval(RemovalNotification<String, List<String>> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User's groups removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<Integer, String> idToUserLoader = new CacheLoader<Integer, String>(){

        public String load(Integer userId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by id=" + userId));
            User user = UsersGroupsCache.this.getUserFromDB(null, userId);
            if (user != null) {
                UsersGroupsCache.this.userToIdCache.put((Object)user.getName(), (Object)userId);
                return user.getName();
            }
            throw new UserNotFoundException("User (" + userId + ") was not found.");
        }
    };
    private RemovalListener<Integer, String> idToUserRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<String, Integer> userToIdLoader = new CacheLoader<String, Integer>(){

        public Integer load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by name=" + userName));
            User user = UsersGroupsCache.this.getUserFromDB(userName, null);
            if (user != null) {
                UsersGroupsCache.this.idToUserCache.put((Object)user.getId(), (Object)userName);
                return user.getId();
            }
            throw new UserNotFoundException("User (" + userName + ") was not found.");
        }
    };
    private RemovalListener<String, Integer> userToIdsNameRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<Integer, String> idToGroupLoader = new CacheLoader<Integer, String>(){

        public String load(Integer groupId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by id=" + groupId));
            Group group = UsersGroupsCache.this.getGroupFromDB(null, groupId);
            if (group != null) {
                UsersGroupsCache.this.groupToIdCache.put((Object)group.getName(), (Object)groupId);
                return group.getName();
            }
            throw new GroupNotFoundException("Group (" + groupId + ") was not found.");
        }
    };
    private RemovalListener<Integer, String> idToGroupsRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private CacheLoader<String, Integer> groupToIdsLoader = new CacheLoader<String, Integer>(){

        public Integer load(String groupName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by name=" + groupName));
            Group group = UsersGroupsCache.this.getGroupFromDB(groupName, null);
            if (group != null) {
                UsersGroupsCache.this.idToGroupCache.put((Object)group.getId(), (Object)groupName);
                return group.getId();
            }
            throw new GroupNotFoundException("Group (" + groupName + ") was not found.");
        }
    };
    private RemovalListener<String, Integer> groupToIdsRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
        }
    };
    private final UserGroupDataAccess userGroupDataAccess;
    private final GroupDataAccess<Group> groupDataAccess;
    private final UserDataAccess<User> userDataAccess;
    private final boolean isConfigured;

    public UsersGroupsCache(UserDataAccess uda, UserGroupDataAccess ugda, GroupDataAccess gda, int evectionTime, int lrumax) {
        this.userDataAccess = uda;
        this.userGroupDataAccess = ugda;
        this.groupDataAccess = gda;
        this.userToGroupsCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.userToGroupsRemoval).build(this.userToGroupsLoader);
        this.idToUserCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.idToUserRemoval).build(this.idToUserLoader);
        this.userToIdCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.userToIdsNameRemoval).build(this.userToIdLoader);
        this.idToGroupCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.idToGroupsRemoval).build(this.idToGroupLoader);
        this.groupToIdCache = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.groupToIdsRemoval).build(this.groupToIdsLoader);
        this.isConfigured = this.userDataAccess != null && this.userGroupDataAccess != null && this.groupDataAccess != null;
    }

    Integer addUserIfNotInCache(String userName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (userName == null) {
            return null;
        }
        Integer userId = (Integer)this.userToIdCache.getIfPresent((Object)userName);
        if (userId != null) {
            this.LOG.debug((Object)("User " + userName + " is already in cache with id=" + userId));
            return userId;
        }
        this.addUser(userName);
        return this.getUserIdFromCache(userName);
    }

    void addUser(String userName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null) {
            return;
        }
        this.LOG.debug((Object)("Add user to DB name=" + userName));
        User user = this.addUserToDB(userName);
        this.LOG.debug((Object)("User Added " + user));
        this.addUserToCache(user.getId(), user.getName());
    }

    private void addUserToCache(Integer userId, String userName) {
        this.idToUserCache.put((Object)userId, (Object)userName);
        this.userToIdCache.put((Object)userName, (Object)userId);
    }

    void removeUser(String userName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove user from DB name=" + userName));
        Integer userId = this.getUserId(userName);
        this.removeUserFromDB(userId);
        this.removeUserFromCache(userId, userName);
    }

    void removeUserFromCache(String userName) {
        if (userName != null) {
            this.removeUserFromCache((Integer)this.userToIdCache.getIfPresent((Object)userName), userName);
        }
    }

    private void removeUserFromCache(Integer userId, String userName) {
        if (userId != null) {
            this.idToUserCache.invalidate((Object)userId);
        }
        if (userName != null) {
            this.userToIdCache.invalidate((Object)userName);
            this.userToGroupsCache.invalidate((Object)userName);
        }
    }

    int getUserId(String userName) throws IOException {
        if (!this.isConfigured) {
            return 0;
        }
        if (userName == null) {
            return 0;
        }
        try {
            return (Integer)this.userToIdCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                return 0;
            }
            throw new IOException(e);
        }
    }

    Integer getUserIdFromCache(String userName) {
        if (userName == null) {
            return 0;
        }
        return (Integer)this.userToIdCache.getIfPresent((Object)userName);
    }

    String getUserName(Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (userId == null || userId <= 0) {
            return null;
        }
        try {
            return (String)this.idToUserCache.get((Object)userId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    Integer addGroupIfNotInCache(String groupName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (groupName == null) {
            return null;
        }
        Integer groupId = (Integer)this.groupToIdCache.getIfPresent((Object)groupName);
        if (groupId != null) {
            this.LOG.debug((Object)("Group " + groupName + " is already in cache with id=" + groupId));
            return groupId;
        }
        this.addGroup(groupName);
        return this.getGroupIdFromCache(groupName);
    }

    void addGroup(String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Add group to DB name=" + groupName));
        Group group = this.addGroupToDB(groupName);
        this.LOG.debug((Object)("Group Added " + group));
        this.addGroupToCache(group.getId(), group.getName());
    }

    private void addGroupToCache(Integer groupId, String groupName) {
        this.idToGroupCache.put((Object)groupId, (Object)groupName);
        this.groupToIdCache.put((Object)groupName, (Object)groupId);
    }

    void removeGroup(String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove group from DB name=" + groupName));
        Integer groupId = this.getGroupId(groupName);
        this.removeGroupFromDB(groupId);
        this.removeGroupFromCache(groupId, groupName);
    }

    void removeGroupFromCache(String groupName) {
        if (groupName != null) {
            this.removeGroupFromCache((Integer)this.groupToIdCache.getIfPresent((Object)groupName), groupName);
        }
    }

    private void removeGroupFromCache(Integer groupId, String groupName) {
        if (groupId != null) {
            this.idToGroupCache.invalidate((Object)groupId);
        }
        if (groupName != null) {
            this.groupToIdCache.invalidate((Object)groupName);
            ConcurrentMap u2gMap = this.userToGroupsCache.asMap();
            for (String user : u2gMap.keySet()) {
                if (!((List)u2gMap.get(user)).contains(groupName)) continue;
                List userGroups = (List)this.userToGroupsCache.getIfPresent((Object)user);
                userGroups.remove(groupName);
                if (!userGroups.isEmpty()) continue;
                this.userToGroupsCache.invalidate((Object)user);
            }
        }
    }

    int getGroupId(String groupName) throws IOException {
        if (!this.isConfigured) {
            return 0;
        }
        if (groupName == null) {
            return 0;
        }
        try {
            return (Integer)this.groupToIdCache.get((Object)groupName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                return 0;
            }
            throw new IOException(e);
        }
    }

    Integer getGroupIdFromCache(String groupName) {
        if (groupName == null) {
            return 0;
        }
        return (Integer)this.groupToIdCache.getIfPresent((Object)groupName);
    }

    String getGroupName(Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (groupId == null || groupId <= 0) {
            return null;
        }
        try {
            return (String)this.idToGroupCache.get((Object)groupId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    void removeUserFromGroup(String userName, String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null || groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove user-group from DB user=" + userName + ", group=" + groupName));
        Integer userId = this.getUserId(userName);
        Integer groupId = this.getGroupId(groupName);
        this.removeUserFromGroupFromDB(userId, groupId);
        this.removeUserFromGroupInCache(userName, groupName);
    }

    List<String> getGroups(String user) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (user == null) {
            return null;
        }
        try {
            return (List)this.userToGroupsCache.get((Object)user);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupsNotFoundForUserException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    List<String> getGroupsFromCache(String user) throws IOException {
        if (user == null) {
            return null;
        }
        return (List)this.userToGroupsCache.getIfPresent((Object)user);
    }

    void removeUserGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (cacheOnly) {
            if (user != null && group == null) {
                this.removeUserFromCache(user);
            } else if (user == null && group != null) {
                this.removeGroupFromCache(group);
            } else if (user != null && group != null) {
                this.removeUserFromGroupInCache(user, group);
            }
        } else if (user != null && group == null) {
            this.removeUser(user);
        } else if (user == null && group != null) {
            this.removeGroup(group);
        } else if (user != null && group != null) {
            this.removeUserFromGroup(user, group);
        }
    }

    void addUserGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (cacheOnly) {
            if (user != null && group != null) {
                this.addUserToGroupsInCache(user, Arrays.asList(group));
            }
        } else {
            this.addUserGroupTx(user, group);
        }
    }

    void addUserGroupTx(String user, String group) throws IOException {
        this.addUserGroupsTx(user, new String[]{group});
    }

    void addUserToGroup(String user, String group) throws IOException {
        this.addUserGroups(user, new String[]{group});
    }

    void addUserGroupsTx(String user, String[] groups) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        try {
            this.addUserGroupsInternalTx(user, groups);
        }
        catch (ForeignKeyConstraintViolationException ex) {
            this.removeUserFromCache(user);
            for (String group : groups) {
                this.removeGroupFromCache(group);
            }
            this.addUserGroupsInternalTx(user, groups);
        }
        catch (UniqueKeyConstraintViolationException ex) {
            this.LOG.debug((Object)("User/Group was already added: " + (Object)((Object)ex)));
        }
    }

    private void addUserGroupsInternalTx(final String user, final String[] grps) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.ADD_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.addUserGroups(user, grps);
                return null;
            }
        }.handle();
    }

    void addUserGroups(String user, String[] grps) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        this.LOG.debug((Object)("Add user (" + user + ") to groups " + grps));
        Collection groups = null;
        if (grps != null) {
            groups = Collections2.filter(Arrays.asList(grps), (Predicate)Predicates.notNull());
        }
        Integer userId = null;
        if (user != null) {
            List availableGroups = (List)this.userToGroupsCache.getIfPresent((Object)user);
            if (availableGroups != null && groups != null && !groups.isEmpty() && availableGroups.containsAll(groups)) {
                this.LOG.debug((Object)("Groups (" + grps + ") already available in the cache for user (" + user + ")"));
                return;
            }
            userId = this.addUserIfNotInCache(user);
        }
        if (groups != null && !groups.isEmpty()) {
            ArrayList groupIds = Lists.newArrayList();
            for (String group : groups) {
                Integer groupId = this.addGroupIfNotInCache(group);
                groupIds.add(groupId);
            }
            if (userId != null) {
                this.userGroupDataAccess.addUserToGroups(userId.intValue(), (List)groupIds);
                this.addUserToGroupsInCache(user, groups);
            }
        }
    }

    void addUserToGroupsInCache(String user, Collection<String> groups) {
        ArrayList currentGroups = (ArrayList)this.userToGroupsCache.getIfPresent((Object)user);
        if (currentGroups == null) {
            currentGroups = new ArrayList();
            this.userToGroupsCache.put((Object)user, currentGroups);
        }
        HashSet<String> newGroups = new HashSet<String>();
        newGroups.addAll(groups);
        newGroups.removeAll(currentGroups);
        currentGroups.addAll(newGroups);
    }

    void removeUserFromGroupInCache(String user, String group) {
        List currentGroups = (List)this.userToGroupsCache.getIfPresent((Object)user);
        if (currentGroups == null) {
            return;
        }
        currentGroups.remove(group);
        if (currentGroups.isEmpty()) {
            this.userToGroupsCache.invalidate((Object)user);
        }
    }

    void clear() {
        this.userToGroupsCache.invalidateAll();
        this.idToUserCache.invalidateAll();
        this.userToIdCache.invalidateAll();
        this.idToGroupCache.invalidateAll();
        this.groupToIdCache.invalidateAll();
    }

    private User getUserFromDB(final String userName, final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (User)new LightWeightRequestHandler(UsersOperationsType.GET_USER){

            public Object performTask() throws StorageException, IOException {
                return userName == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue()) : (User)UsersGroupsCache.this.userDataAccess.getUser(userName);
            }
        }.handle();
    }

    private User addUserToDB(final String userName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (User)new LightWeightRequestHandler(UsersOperationsType.ADD_USER){

            public Object performTask() throws StorageException, IOException {
                return UsersGroupsCache.this.userDataAccess.addUser(userName);
            }
        }.handle();
    }

    private void removeUserFromDB(final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.userDataAccess.removeUser(userId.intValue());
                return null;
            }
        }.handle();
    }

    private Group getGroupFromDB(final String groupName, final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (Group)new LightWeightRequestHandler(UsersOperationsType.GET_GROUP){

            public Object performTask() throws StorageException, IOException {
                return groupName == null ? (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupId.intValue()) : (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupName);
            }
        }.handle();
    }

    private Group addGroupToDB(final String groupName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (Group)new LightWeightRequestHandler(UsersOperationsType.ADD_GROUP){

            public Object performTask() throws StorageException, IOException {
                return UsersGroupsCache.this.groupDataAccess.addGroup(groupName);
            }
        }.handle();
    }

    private void removeGroupFromDB(final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_GROUP){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.groupDataAccess.removeGroup(groupId.intValue());
                return null;
            }
        }.handle();
    }

    private void removeUserFromGroupFromDB(final Integer userId, final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.userGroupDataAccess.removeUserFromGroup(userId.intValue(), groupId.intValue());
                return null;
            }
        }.handle();
    }

    private List<Group> getGroupsFromDB(final String userName, final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (List)new LightWeightRequestHandler(UsersOperationsType.GET_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                User user;
                List result = null;
                boolean transactionActive = connector.isTransactionActive();
                if (!transactionActive) {
                    connector.beginTransaction();
                }
                User user2 = user = userId == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userName) : (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue());
                if (user != null) {
                    List groups;
                    result = groups = UsersGroupsCache.this.userGroupDataAccess.getGroupsForUser(user.getId());
                }
                if (!transactionActive) {
                    connector.commit();
                }
                return result;
            }
        }.handle();
    }

    private class GroupsNotFoundForUserException
    extends Exception {
        public GroupsNotFoundForUserException(String message) {
            super(message);
        }
    }

    private class GroupNotFoundException
    extends Exception {
        public GroupNotFoundException(String message) {
            super(message);
        }
    }

    private class UserNotFoundException
    extends Exception {
        public UserNotFoundException(String message) {
            super(message);
        }
    }

    private static enum UsersOperationsType implements RequestHandler.OperationType
    {
        ADD_USER,
        REMOVE_USER,
        ADD_GROUP,
        REMOVE_GROUP,
        GET_USER_GROUPS,
        GET_USER,
        GET_GROUP,
        ADD_USER_GROUPS,
        REMOVE_USER_GROUPS;

    }
}

