/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.LogAggregationReportPBImpl;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;
import org.apache.hadoop.yarn.server.api.records.impl.pb.NodeStatusPBImpl;

public class NodeHeartbeatRequestPBImpl
extends NodeHeartbeatRequest {
    YarnServerCommonServiceProtos.NodeHeartbeatRequestProto proto = YarnServerCommonServiceProtos.NodeHeartbeatRequestProto.getDefaultInstance();
    YarnServerCommonServiceProtos.NodeHeartbeatRequestProto.Builder builder = null;
    boolean viaProto = false;
    private NodeStatus nodeStatus = null;
    private MasterKey lastKnownContainerTokenMasterKey = null;
    private MasterKey lastKnownNMTokenMasterKey = null;
    private Set<NodeLabel> labels = null;
    private List<LogAggregationReport> logAggregationReportsForApps = null;
    private Set<ApplicationId> updatedApplicationsWithNewCryptoMaterial = null;

    public NodeHeartbeatRequestPBImpl() {
        this.builder = YarnServerCommonServiceProtos.NodeHeartbeatRequestProto.newBuilder();
    }

    public NodeHeartbeatRequestPBImpl(YarnServerCommonServiceProtos.NodeHeartbeatRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.NodeHeartbeatRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((NodeHeartbeatRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    private void mergeLocalToBuilder() {
        if (this.nodeStatus != null) {
            this.builder.setNodeStatus(this.convertToProtoFormat(this.nodeStatus));
        }
        if (this.lastKnownContainerTokenMasterKey != null) {
            this.builder.setLastKnownContainerTokenMasterKey(this.convertToProtoFormat(this.lastKnownContainerTokenMasterKey));
        }
        if (this.lastKnownNMTokenMasterKey != null) {
            this.builder.setLastKnownNmTokenMasterKey(this.convertToProtoFormat(this.lastKnownNMTokenMasterKey));
        }
        if (this.labels != null) {
            this.builder.clearNodeLabels();
            YarnServerCommonServiceProtos.NodeLabelsProto.Builder newBuilder = YarnServerCommonServiceProtos.NodeLabelsProto.newBuilder();
            for (NodeLabel label : this.labels) {
                newBuilder.addNodeLabels(this.convertToProtoFormat(label));
            }
            this.builder.setNodeLabels(newBuilder.build());
        }
        if (this.logAggregationReportsForApps != null) {
            this.addLogAggregationStatusForAppsToProto();
        }
        if (this.updatedApplicationsWithNewCryptoMaterial != null) {
            this.addUpdatedApplicationsWithNewCryptoMaterialToProto();
        }
    }

    private void addLogAggregationStatusForAppsToProto() {
        this.maybeInitBuilder();
        this.builder.clearLogAggregationReportsForApps();
        if (this.logAggregationReportsForApps == null) {
            return;
        }
        Iterable<YarnServerCommonServiceProtos.LogAggregationReportProto> it = new Iterable<YarnServerCommonServiceProtos.LogAggregationReportProto>(){

            @Override
            public Iterator<YarnServerCommonServiceProtos.LogAggregationReportProto> iterator() {
                return new Iterator<YarnServerCommonServiceProtos.LogAggregationReportProto>(){
                    private Iterator<LogAggregationReport> iter;
                    {
                        this.iter = NodeHeartbeatRequestPBImpl.this.logAggregationReportsForApps.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServerCommonServiceProtos.LogAggregationReportProto next() {
                        return NodeHeartbeatRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllLogAggregationReportsForApps((Iterable<? extends YarnServerCommonServiceProtos.LogAggregationReportProto>)it);
    }

    private void addUpdatedApplicationsWithNewCryptoMaterialToProto() {
        this.maybeInitBuilder();
        this.builder.clearUpdatedApplicationsWithNewCryptoMaterial();
        if (this.updatedApplicationsWithNewCryptoMaterial == null) {
            return;
        }
        for (ApplicationId appId : this.updatedApplicationsWithNewCryptoMaterial) {
            this.builder.addUpdatedApplicationsWithNewCryptoMaterial(YarnProtos.ApplicationIdProto.newBuilder().setClusterTimestamp(appId.getClusterTimestamp()).setId(appId.getId()));
        }
    }

    private YarnServerCommonServiceProtos.LogAggregationReportProto convertToProtoFormat(LogAggregationReport value) {
        return ((LogAggregationReportPBImpl)value).getProto();
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.NodeHeartbeatRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public NodeStatus getNodeStatus() {
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder nodeHeartbeatRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeStatus != null) {
            return this.nodeStatus;
        }
        if (!p.hasNodeStatus()) {
            return null;
        }
        this.nodeStatus = this.convertFromProtoFormat(p.getNodeStatus());
        return this.nodeStatus;
    }

    @Override
    public void setNodeStatus(NodeStatus nodeStatus) {
        this.maybeInitBuilder();
        if (nodeStatus == null) {
            this.builder.clearNodeStatus();
        }
        this.nodeStatus = nodeStatus;
    }

    @Override
    public MasterKey getLastKnownContainerTokenMasterKey() {
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder nodeHeartbeatRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.lastKnownContainerTokenMasterKey != null) {
            return this.lastKnownContainerTokenMasterKey;
        }
        if (!p.hasLastKnownContainerTokenMasterKey()) {
            return null;
        }
        this.lastKnownContainerTokenMasterKey = this.convertFromProtoFormat(p.getLastKnownContainerTokenMasterKey());
        return this.lastKnownContainerTokenMasterKey;
    }

    @Override
    public void setLastKnownContainerTokenMasterKey(MasterKey masterKey) {
        this.maybeInitBuilder();
        if (masterKey == null) {
            this.builder.clearLastKnownContainerTokenMasterKey();
        }
        this.lastKnownContainerTokenMasterKey = masterKey;
    }

    @Override
    public MasterKey getLastKnownNMTokenMasterKey() {
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder nodeHeartbeatRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.lastKnownNMTokenMasterKey != null) {
            return this.lastKnownNMTokenMasterKey;
        }
        if (!p.hasLastKnownNmTokenMasterKey()) {
            return null;
        }
        this.lastKnownNMTokenMasterKey = this.convertFromProtoFormat(p.getLastKnownNmTokenMasterKey());
        return this.lastKnownNMTokenMasterKey;
    }

    @Override
    public void setLastKnownNMTokenMasterKey(MasterKey masterKey) {
        this.maybeInitBuilder();
        if (masterKey == null) {
            this.builder.clearLastKnownNmTokenMasterKey();
        }
        this.lastKnownNMTokenMasterKey = masterKey;
    }

    private NodeStatusPBImpl convertFromProtoFormat(YarnServerCommonProtos.NodeStatusProto p) {
        return new NodeStatusPBImpl(p);
    }

    private YarnServerCommonProtos.NodeStatusProto convertToProtoFormat(NodeStatus t) {
        return ((NodeStatusPBImpl)t).getProto();
    }

    private MasterKeyPBImpl convertFromProtoFormat(YarnServerCommonProtos.MasterKeyProto p) {
        return new MasterKeyPBImpl(p);
    }

    private YarnServerCommonProtos.MasterKeyProto convertToProtoFormat(MasterKey t) {
        return ((MasterKeyPBImpl)t).getProto();
    }

    @Override
    public Set<NodeLabel> getNodeLabels() {
        this.initNodeLabels();
        return this.labels;
    }

    @Override
    public void setNodeLabels(Set<NodeLabel> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.labels = nodeLabels;
    }

    private void initNodeLabels() {
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p;
        if (this.labels != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder nodeHeartbeatRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabels()) {
            this.labels = null;
            return;
        }
        YarnServerCommonServiceProtos.NodeLabelsProto nodeLabels = p.getNodeLabels();
        this.labels = new HashSet<NodeLabel>();
        for (YarnProtos.NodeLabelProto nlp : nodeLabels.getNodeLabelsList()) {
            this.labels.add((NodeLabel)this.convertFromProtoFormat(nlp));
        }
    }

    private void initUpdatedApplicationWithNewCryptoMaterial() {
        if (this.updatedApplicationsWithNewCryptoMaterial != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationIdProto> list = p.getUpdatedApplicationsWithNewCryptoMaterialList();
        this.updatedApplicationsWithNewCryptoMaterial = new HashSet<ApplicationId>();
        for (YarnProtos.ApplicationIdProto aip : list) {
            this.updatedApplicationsWithNewCryptoMaterial.add((ApplicationId)this.convertFromProtoFormat(aip));
        }
    }

    @Override
    public Set<ApplicationId> getUpdatedApplicationsWithNewCryptoMaterial() {
        this.initUpdatedApplicationWithNewCryptoMaterial();
        return this.updatedApplicationsWithNewCryptoMaterial;
    }

    @Override
    public void setUpdatedApplicationsWithNewCryptoMaterial(Set<ApplicationId> updatedApplicationsWithNewCryptoMaterial) {
        if (updatedApplicationsWithNewCryptoMaterial == null) {
            return;
        }
        this.maybeInitBuilder();
        this.builder.clearUpdatedApplicationsWithNewCryptoMaterial();
        this.updatedApplicationsWithNewCryptoMaterial = updatedApplicationsWithNewCryptoMaterial;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private NodeLabelPBImpl convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    @Override
    public List<LogAggregationReport> getLogAggregationReportsForApps() {
        if (this.logAggregationReportsForApps != null) {
            return this.logAggregationReportsForApps;
        }
        this.initLogAggregationReportsForApps();
        return this.logAggregationReportsForApps;
    }

    private void initLogAggregationReportsForApps() {
        YarnServerCommonServiceProtos.NodeHeartbeatRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.LogAggregationReportProto> list = p.getLogAggregationReportsForAppsList();
        this.logAggregationReportsForApps = new ArrayList<LogAggregationReport>();
        for (YarnServerCommonServiceProtos.LogAggregationReportProto c : list) {
            this.logAggregationReportsForApps.add(this.convertFromProtoFormat(c));
        }
    }

    private LogAggregationReport convertFromProtoFormat(YarnServerCommonServiceProtos.LogAggregationReportProto logAggregationReport) {
        return new LogAggregationReportPBImpl(logAggregationReport);
    }

    @Override
    public void setLogAggregationReportsForApps(List<LogAggregationReport> logAggregationStatusForApps) {
        if (logAggregationStatusForApps == null) {
            this.builder.clearLogAggregationReportsForApps();
        }
        this.logAggregationReportsForApps = logAggregationStatusForApps;
    }
}

