/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgOps {
    private static final Logger log = LoggerFactory.getLogger(ArgOps.class);

    public static List<Object> triple(String msg, int min, int max) {
        ArrayList<Object> l = new ArrayList<Object>(3);
        l.add(msg);
        l.add(min);
        l.add(max);
        return l;
    }

    public static void applyFileSystemBinding(String filesystemBinding, Configuration conf) {
        if (filesystemBinding != null) {
            FileSystem.setDefaultUri((Configuration)conf, (String)filesystemBinding);
        }
    }

    public static void splitPairs(Collection<String> pairs, Map<String, String> dest) {
        for (String prop : pairs) {
            String[] keyval = prop.split("=", 2);
            if (keyval.length != 2) continue;
            dest.put(keyval[0], keyval[1]);
        }
    }

    public static void applyDefinitions(Map<String, String> definitionMap, Configuration conf) {
        for (Map.Entry<String, String> entry : definitionMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            log.debug("configuration[{}]<=\"{}\"", (Object)key, (Object)val);
            conf.set(key, val, "command line");
        }
    }

    public static Map<String, String> convertTupleListToMap(String description, List<String> list) throws BadCommandArgumentsException {
        HashMap<String, String> results = new HashMap<String, String>();
        if (list != null && !list.isEmpty()) {
            int size = list.size();
            if (size % 2 != 0) {
                throw new BadCommandArgumentsException("Failed to parse " + description, new Object[0]);
            }
            int count = 0;
            while (count < size) {
                String key = list.get(count);
                String val = list.get(count + 1);
                if (results.get(key) != null) {
                    throw new BadCommandArgumentsException("Duplicate entry for " + description + ": " + key, new Object[0]);
                }
                results.put(key, val);
                count += 2;
            }
        }
        return results;
    }

    public static Map<String, Map<String, String>> convertTripleListToMaps(String description, List<String> list) throws BadCommandArgumentsException {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            int size = list.size();
            if (size % 3 != 0) {
                throw new BadCommandArgumentsException("Failed to parse " + description, new Object[0]);
            }
            int count = 0;
            while (count < size) {
                String role = list.get(count);
                String key = list.get(count + 1);
                String val = list.get(count + 2);
                HashMap<String, String> roleMap = (HashMap<String, String>)results.get(role);
                if (roleMap == null) {
                    roleMap = new HashMap<String, String>();
                    results.put(role, roleMap);
                }
                if (roleMap.get(key) != null) {
                    throw new BadCommandArgumentsException("Duplicate entry for " + description + ": for key " + key + " under " + role, new Object[0]);
                }
                roleMap.put(key, val);
                count += 3;
            }
        }
        return results;
    }
}

