/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.conf;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.server.services.security.SecurityUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class AggregateConf {
    private String name;
    private ConfTree resources;
    private ConfTree internal;
    private ConfTree appConf;
    private ConfTreeOperations resourceOperations;
    private ConfTreeOperations appConfOperations;
    private ConfTreeOperations internalOperations;
    private String passphrase;

    public AggregateConf() {
        this(new ConfTree(), new ConfTree(), new ConfTree());
    }

    public AggregateConf(String name) {
        this(new ConfTree(), new ConfTree(), new ConfTree());
        this.name = name;
    }

    public AggregateConf(ConfTree resources, ConfTree appConf, ConfTree internal) {
        this.setResources(resources);
        this.setAppConf(appConf);
        this.setInternal(internal);
    }

    public AggregateConf(AggregateConf instanceDefinition) throws IOException {
        ConfTreeOperations resourcesSnapshot = ConfTreeOperations.fromInstance(instanceDefinition.getResources());
        ConfTreeOperations appConfSnapshot = ConfTreeOperations.fromInstance(instanceDefinition.getAppConf());
        ConfTreeOperations internalsSnapshot = ConfTreeOperations.fromInstance(instanceDefinition.getInternal());
        this.setResources(resourcesSnapshot.confTree);
        this.setAppConf(appConfSnapshot.confTree);
        this.setInternal(internalsSnapshot.confTree);
    }

    public void setResources(ConfTree resources) {
        this.resources = resources;
        this.resourceOperations = new ConfTreeOperations(resources);
    }

    public void setAppConf(ConfTree appConf) {
        this.appConf = appConf;
        this.appConfOperations = new ConfTreeOperations(appConf);
    }

    public ConfTree getInternal() {
        return this.internal;
    }

    public void setInternal(ConfTree internal) {
        this.internal = internal;
        this.internalOperations = new ConfTreeOperations(internal);
    }

    public ConfTree getResources() {
        return this.resources;
    }

    public ConfTree getAppConf() {
        return this.appConf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public ConfTreeOperations getResourceOperations() {
        return this.resourceOperations;
    }

    @JsonIgnore
    public ConfTreeOperations getAppConfOperations() {
        return this.appConfOperations;
    }

    @JsonIgnore
    public ConfTreeOperations getInternalOperations() {
        return this.internalOperations;
    }

    @JsonIgnore
    public boolean isComplete() {
        return this.resources != null && this.appConf != null && this.internal != null;
    }

    public void validate() throws BadConfigException {
        if (!this.isComplete()) {
            throw new BadConfigException("Incomplete instance %s", this);
        }
        this.resourceOperations.validate();
        this.internalOperations.validate();
        this.appConfOperations.validate();
    }

    public void resolve() throws BadConfigException {
        this.validate();
        this.resourceOperations.resolve();
        this.internalOperations.resolve();
        this.appConfOperations.resolve();
    }

    @JsonIgnore
    public String getPassphrase() {
        if (this.passphrase == null) {
            this.passphrase = SecurityUtils.randomAlphanumeric(Integer.valueOf("50"));
        }
        return this.passphrase;
    }

    public boolean isVersioned() {
        return StringUtils.isNotEmpty((String)this.getAppConfOperations().getGlobalOptions().get("site.global.app_version"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(",\n\"internal\": ").append(this.internal);
        sb.append(",\n\"resources\": ").append(this.resources);
        sb.append(",\n\"appConf\" :").append(this.appConf);
        sb.append('}');
        return sb.toString();
    }
}

