/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.core.launch.AbstractLauncher;
import org.apache.slider.core.launch.CredentialUtils;
import org.apache.slider.core.launch.LaunchedApplication;
import org.apache.slider.core.launch.SerializedApplicationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppMasterLauncher
extends AbstractLauncher {
    private static final Logger log = LoggerFactory.getLogger(AppMasterLauncher.class);
    public final YarnClientApplication application;
    public final String name;
    public final String type;
    public final ApplicationSubmissionContext submissionContext;
    public final ApplicationId appId;
    public final boolean secureCluster;
    private int maxAppAttempts = 0;
    private boolean keepContainersOverRestarts = true;
    private String queue = "default";
    private int priority = 1;
    private final Resource resource = (Resource)Records.newRecord(Resource.class);
    private final SliderYarnClientImpl yarnClient;
    private Long submitTime;

    public AppMasterLauncher(String name, String type, Configuration conf, CoreFileSystem fs, SliderYarnClientImpl yarnClient, boolean secureCluster, Map<String, String> options, Map<String, String> resourceGlobalOptions, Set<String> applicationTags, Credentials credentials) throws IOException, YarnException {
        super(conf, fs, credentials);
        this.yarnClient = yarnClient;
        this.application = yarnClient.createApplication();
        this.name = name;
        this.type = type;
        this.secureCluster = secureCluster;
        this.submissionContext = this.application.getApplicationSubmissionContext();
        this.appId = this.submissionContext.getApplicationId();
        this.submissionContext.setApplicationName(name);
        this.submissionContext.setApplicationType(type);
        if (!applicationTags.isEmpty()) {
            this.submissionContext.setApplicationTags(applicationTags);
        }
        this.submissionContext.setNodeLabelExpression(this.extractLabelExpression(options));
        this.extractAmRetryCount(this.submissionContext, resourceGlobalOptions);
        this.extractResourceRequirements(this.resource, options);
        this.extractLogAggregationContext(resourceGlobalOptions);
    }

    public void setMaxAppAttempts(int maxAppAttempts) {
        this.maxAppAttempts = maxAppAttempts;
    }

    public void setKeepContainersOverRestarts(boolean keepContainersOverRestarts) {
        this.keepContainersOverRestarts = keepContainersOverRestarts;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setMemory(int memory) {
        this.resource.setMemory(memory);
    }

    public void setVirtualCores(int cores) {
        this.resource.setVirtualCores(cores);
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    public boolean isKeepContainersOverRestarts() {
        return this.keepContainersOverRestarts;
    }

    public String getQueue() {
        return this.queue;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ApplicationSubmissionContext completeAppMasterLaunch() throws IOException {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.priority);
        this.submissionContext.setPriority(pri);
        this.submissionContext.setQueue(this.queue);
        this.submissionContext.setResource(this.resource);
        this.submissionContext.setLogAggregationContext(this.logAggregationContext);
        if (this.keepContainersOverRestarts) {
            log.debug("Requesting cluster stays running over AM failure");
            this.submissionContext.setKeepContainersAcrossApplicationAttempts(true);
        }
        if (this.maxAppAttempts > 0) {
            log.debug("Setting max AM attempts to {}", (Object)this.maxAppAttempts);
            this.submissionContext.setMaxAppAttempts(this.maxAppAttempts);
        }
        if (this.secureCluster) {
            log.debug("Credentials: {}", (Object)CredentialUtils.dumpTokens(this.getCredentials(), "\n"));
        } else {
            this.propagateUsernameInInsecureCluster();
        }
        this.completeContainerLaunch();
        this.submissionContext.setAMContainerSpec(this.containerLaunchContext);
        return this.submissionContext;
    }

    public LaunchedApplication submitApplication() throws IOException, YarnException {
        this.completeAppMasterLaunch();
        log.info("Submitting application to Resource Manager");
        ApplicationId applicationId = this.yarnClient.submitApplication(this.submissionContext);
        this.submitTime = System.currentTimeMillis();
        return new LaunchedApplication(applicationId, this.yarnClient);
    }

    public SerializedApplicationReport createSerializedApplicationReport() {
        SerializedApplicationReport sar = new SerializedApplicationReport();
        sar.applicationId = this.appId.toString();
        sar.name = this.name;
        sar.applicationType = this.type;
        sar.queue = this.queue;
        sar.submitTime = this.submitTime;
        return sar;
    }
}

