/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.main.ExitCodeProvider;
import org.apache.slider.providers.MonitorDetail;
import org.apache.slider.providers.ProviderCompleted;
import org.apache.slider.providers.ProviderCore;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderService;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.state.ContainerReleaseSelector;
import org.apache.slider.server.appmaster.state.MostRecentContainerReleaseSelector;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.agent.AgentRestOperations;
import org.apache.slider.server.services.workflow.ForkedProcessService;
import org.apache.slider.server.services.workflow.ServiceParent;
import org.apache.slider.server.services.workflow.WorkflowSequenceService;
import org.apache.slider.server.services.yarnregistry.YarnRegistryViewForProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderService
extends WorkflowSequenceService
implements ProviderCore,
SliderKeys,
ProviderService {
    private static final Logger log = LoggerFactory.getLogger(AbstractProviderService.class);
    protected StateAccessForProviders amState;
    protected AgentRestOperations restOps;
    protected URL amWebAPI;
    protected YarnRegistryViewForProviders yarnRegistry;
    protected QueueAccess queueAccess;

    protected AbstractProviderService(String name) {
        super(name);
        this.setStopIfNoChildServicesAtStartup(false);
    }

    @Override
    public Configuration getConf() {
        return this.getConfig();
    }

    public StateAccessForProviders getAmState() {
        return this.amState;
    }

    public QueueAccess getQueueAccess() {
        return this.queueAccess;
    }

    public void setAmState(StateAccessForProviders amState) {
        this.amState = amState;
    }

    @Override
    public String getHumanName() {
        return this.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void bind(StateAccessForProviders stateAccessor, QueueAccess queueAccess, List<Container> liveContainers) {
        this.amState = stateAccessor;
        this.queueAccess = queueAccess;
    }

    @Override
    public void bindToYarnRegistry(YarnRegistryViewForProviders yarnRegistry) {
        this.yarnRegistry = yarnRegistry;
    }

    public YarnRegistryViewForProviders getYarnRegistry() {
        return this.yarnRegistry;
    }

    @Override
    public AgentRestOperations getAgentRestOperations() {
        return this.restOps;
    }

    @Override
    public void notifyContainerCompleted(ContainerId containerId) {
    }

    public void setAgentRestOperations(AgentRestOperations agentRestOperations) {
        this.restOps = agentRestOperations;
    }

    protected Configuration loadProviderConfigurationInformation(File confDir, String siteXMLFilename) throws BadCommandArgumentsException, IOException {
        File siteXML = new File(confDir, siteXMLFilename);
        if (!siteXML.exists()) {
            throw new BadCommandArgumentsException("Configuration directory %s doesn't contain %s - listing is %s", confDir, siteXMLFilename, SliderUtils.listDir(confDir));
        }
        Configuration siteConf = ConfigHelper.loadConfFromFile(siteXML);
        log.info("{} file is at {}", (Object)siteXMLFilename, (Object)siteXML);
        log.info(ConfigHelper.dumpConfigToString(siteConf));
        return siteConf;
    }

    @Override
    public void initializeApplicationConfiguration(AggregateConf instanceDefinition, SliderFileSystem fileSystem, String roleGroup) throws IOException, SliderException {
    }

    @Override
    public void validateApplicationConfiguration(AggregateConf instance, File confDir, boolean secure) throws IOException, SliderException {
    }

    @Override
    public boolean isSupportedRole(String role) {
        List roles = this.getRoles();
        for (ProviderRole providedRole : roles) {
            if (!providedRole.name.equals(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exec(AggregateConf instanceDefinition, File confDir, Map<String, String> env, ProviderCompleted execInProgress) throws IOException, SliderException {
        return false;
    }

    @Override
    public int getExitCode() {
        Throwable cause = this.getFailureCause();
        if (cause != null && cause instanceof ExitCodeProvider) {
            return ((ExitCodeProvider)((Object)cause)).getExitCode();
        }
        ForkedProcessService lastProc = this.latestProcess();
        if (lastProc == null || !lastProc.isProcessTerminated()) {
            return 0;
        }
        return lastProc.getExitCode();
    }

    protected ForkedProcessService latestProcess() {
        Service latest;
        Service current = this.getActiveService();
        Service prev = this.getPreviousService();
        Service service = latest = current != null ? current : prev;
        if (latest instanceof ForkedProcessService) {
            return (ForkedProcessService)latest;
        }
        if (latest instanceof ServiceParent) {
            return this.getFPSFromParentService((ServiceParent)latest);
        }
        return null;
    }

    protected ForkedProcessService getFPSFromParentService(ServiceParent serviceParent) {
        List<Service> services = serviceParent.getServices();
        for (Service s : services) {
            if (!(s instanceof ForkedProcessService)) continue;
            return (ForkedProcessService)s;
        }
        return null;
    }

    protected void maybeStartCommandSequence() {
        if (this.isInState(Service.STATE.STARTED)) {
            this.startNextService();
        }
    }

    protected ForkedProcessService queueCommand(String name, Map<String, String> env, List<String> commands) throws IOException, SliderException {
        ForkedProcessService process = this.buildProcess(name, env, commands);
        this.addService((Service)process);
        return process;
    }

    public ForkedProcessService buildProcess(String name, Map<String, String> env, List<String> commands) throws IOException, SliderException {
        ForkedProcessService process = new ForkedProcessService(name);
        process.init(this.getConfig());
        process.build(env, commands);
        return process;
    }

    @Override
    public Map<String, String> buildProviderStatus() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, MonitorDetail> buildMonitorDetails(ClusterDescription clusterDesc) {
        LinkedHashMap<String, MonitorDetail> details = new LinkedHashMap<String, MonitorDetail>();
        this.buildEndpointDetails(details);
        return details;
    }

    @Override
    public void buildEndpointDetails(Map<String, MonitorDetail> details) {
        ServiceRecord self = this.yarnRegistry.getSelfRegistration();
        List externals = self.external;
        for (Endpoint endpoint : externals) {
            String addressType = endpoint.addressType;
            if (!"uri".equals(addressType)) continue;
            try {
                List urls = RegistryTypeUtils.retrieveAddressURLs((Endpoint)endpoint);
                if (urls.isEmpty()) continue;
                details.put(endpoint.api, new MonitorDetail(((URL)urls.get(0)).toString(), true));
            }
            catch (MalformedURLException | InvalidRecordException throwable) {}
        }
    }

    @Override
    public void applyInitialRegistryDefinitions(URL amWebURI, URL agentOpsURI, URL agentStatusURI, ServiceRecord serviceRecord) throws IOException {
        this.amWebAPI = amWebURI;
    }

    @Override
    public ContainerReleaseSelector createContainerReleaseSelector() {
        return new MostRecentContainerReleaseSelector();
    }

    @Override
    public void releaseAssignedContainer(ContainerId containerId) {
    }

    @Override
    public void addContainerRequest(AMRMClient.ContainerRequest req) {
    }

    @Override
    public void cancelSingleRequest(AMRMClient.ContainerRequest request) {
    }

    @Override
    public int cancelContainerRequests(Priority priority1, Priority priority2, int count) {
        return 0;
    }

    @Override
    public void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
    }

    @Override
    public void execute(List<AbstractRMOperation> operations) {
        for (AbstractRMOperation operation : operations) {
            operation.execute(this);
        }
    }

    @Override
    public void rebuildContainerDetails(List<Container> liveContainers, String applicationId, Map<Integer, ProviderRole> providerRoles) {
    }
}

