/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.slider.common.tools.SliderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTagProvider {
    private static final Logger log = LoggerFactory.getLogger(ComponentTagProvider.class);
    private static String FREE = "free";
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, String>> allTags = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAssignedTag(String component, String containerId, String tag) {
        if (SliderUtils.isSet(component) && SliderUtils.isSet(containerId)) {
            Integer key = null;
            try {
                key = Integer.valueOf(tag);
            }
            catch (NumberFormatException numberFormatException) {}
            if (key != null && key > 0) {
                ConcurrentHashMap<String, String> compTags;
                ConcurrentHashMap<String, String> concurrentHashMap = compTags = this.getComponentSpecificTags(component);
                synchronized (concurrentHashMap) {
                    int index = 1;
                    while (index <= key) {
                        String tempKey = new Integer(index).toString();
                        if (!compTags.containsKey(tempKey)) {
                            compTags.put(tempKey, FREE);
                        }
                        ++index;
                    }
                    compTags.put(key.toString(), containerId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTag(String component, String containerId) {
        if (SliderUtils.isSet(component) && SliderUtils.isSet(containerId)) {
            ConcurrentHashMap<String, String> compTags;
            ConcurrentHashMap<String, String> concurrentHashMap = compTags = this.getComponentSpecificTags(component);
            synchronized (concurrentHashMap) {
                for (String key : compTags.keySet()) {
                    if (!compTags.get(key).equals(containerId)) continue;
                    return key;
                }
                for (String key : compTags.keySet()) {
                    if (!compTags.get(key).equals(FREE)) continue;
                    compTags.put(key, containerId);
                    return key;
                }
                String newKey = new Integer(compTags.size() + 1).toString();
                compTags.put(newKey, containerId);
                return newKey;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTag(String component, String containerId) {
        ConcurrentHashMap<String, String> compTags;
        if (SliderUtils.isSet(component) && SliderUtils.isSet(containerId) && (compTags = this.allTags.get(component)) != null) {
            ConcurrentHashMap<String, String> concurrentHashMap = compTags;
            synchronized (concurrentHashMap) {
                for (String key : compTags.keySet()) {
                    if (!compTags.get(key).equals(containerId)) continue;
                    compTags.put(key, FREE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<String, String> getComponentSpecificTags(String component) {
        if (this.allTags.get(component) == null) {
            ConcurrentHashMap<String, ConcurrentHashMap<String, String>> concurrentHashMap = this.allTags;
            synchronized (concurrentHashMap) {
                if (!this.allTags.containsKey(component)) {
                    this.allTags.put(component, new ConcurrentHashMap());
                }
            }
        }
        return this.allTags.get(component);
    }
}

